/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.msq.exec.WorkerManagerClient;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.rpc.indexing.OverlordClient;

public class IndexerWorkerManagerClient
implements WorkerManagerClient {
    private final OverlordClient overlordClient;

    public IndexerWorkerManagerClient(OverlordClient overlordClient) {
        this.overlordClient = overlordClient;
    }

    @Override
    public String run(String controllerId, MSQWorkerTask task) {
        FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.runTask(controllerId, (Object)task), (boolean)true);
        return controllerId;
    }

    @Override
    public void cancel(String taskId) {
        FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.cancelTask(taskId), (boolean)true);
    }

    @Override
    public Map<String, TaskStatus> statuses(Set<String> taskIds) {
        return (Map)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskStatuses(taskIds), (boolean)true);
    }

    @Override
    public TaskLocation location(String workerId) {
        TaskStatusResponse response = (TaskStatusResponse)FutureUtils.getUnchecked((ListenableFuture)this.overlordClient.taskStatus(workerId), (boolean)true);
        if (response.getStatus() != null) {
            return response.getStatus().getLocation();
        }
        return TaskLocation.unknown();
    }

    @Override
    public void close() {
    }
}

