/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.exec.TaskDataSegmentProvider;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.indexing.IndexerControllerClient;
import org.apache.druid.msq.indexing.IndexerFrameContext;
import org.apache.druid.msq.indexing.IndexerWorkerClient;
import org.apache.druid.msq.indexing.WorkerChatHandler;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.rpc.CoordinatorServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SpecificTaskRetryPolicy;
import org.apache.druid.rpc.indexing.SpecificTaskServiceLocator;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.server.DruidNode;

public class IndexerWorkerContext
implements WorkerContext {
    private static final Logger log = new Logger(IndexerWorkerContext.class);
    private static final long FREQUENCY_CHECK_MILLIS = 1000L;
    private static final long FREQUENCY_CHECK_JITTER = 30L;
    private final TaskToolbox toolbox;
    private final Injector injector;
    private final IndexIO indexIO;
    private final TaskDataSegmentProvider dataSegmentProvider;
    private final ServiceClientFactory clientFactory;
    @GuardedBy(value="this")
    private OverlordClient overlordClient;
    @GuardedBy(value="this")
    private ServiceLocator controllerLocator;

    public IndexerWorkerContext(TaskToolbox toolbox, Injector injector, IndexIO indexIO, TaskDataSegmentProvider dataSegmentProvider, ServiceClientFactory clientFactory) {
        this.toolbox = toolbox;
        this.injector = injector;
        this.indexIO = indexIO;
        this.dataSegmentProvider = dataSegmentProvider;
        this.clientFactory = clientFactory;
    }

    public static IndexerWorkerContext createProductionInstance(TaskToolbox toolbox, Injector injector) {
        IndexIO indexIO = (IndexIO)injector.getInstance(IndexIO.class);
        CoordinatorServiceClient coordinatorServiceClient = ((CoordinatorServiceClient)injector.getInstance(CoordinatorServiceClient.class)).withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        SegmentCacheManager segmentCacheManager = ((SegmentCacheManagerFactory)injector.getInstance(SegmentCacheManagerFactory.class)).manufacturate(new File(toolbox.getIndexingTmpDir(), "segment-fetch"));
        ServiceClientFactory serviceClientFactory = (ServiceClientFactory)injector.getInstance(Key.get(ServiceClientFactory.class, EscalatedGlobal.class));
        return new IndexerWorkerContext(toolbox, injector, indexIO, new TaskDataSegmentProvider(coordinatorServiceClient, segmentCacheManager, indexIO), serviceClientFactory);
    }

    public TaskToolbox toolbox() {
        return this.toolbox;
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.toolbox.getJsonMapper();
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public void registerWorker(Worker worker, Closer closer) {
        WorkerChatHandler chatHandler = new WorkerChatHandler(this.toolbox, worker);
        this.toolbox.getChatHandlerProvider().register(worker.id(), (ChatHandler)chatHandler, false);
        closer.register(() -> this.toolbox.getChatHandlerProvider().unregister(worker.id()));
        closer.register(() -> {
            IndexerWorkerContext indexerWorkerContext = this;
            synchronized (indexerWorkerContext) {
                if (this.controllerLocator != null) {
                    this.controllerLocator.close();
                }
            }
        });
        ExecutorService periodicControllerCheckerExec = Execs.singleThreaded((String)"controller-status-checker-%s");
        closer.register(periodicControllerCheckerExec::shutdownNow);
        ServiceLocator controllerLocator = this.makeControllerLocator(worker.task().getControllerTaskId());
        periodicControllerCheckerExec.submit(() -> this.controllerCheckerRunnable(controllerLocator, worker));
    }

    @VisibleForTesting
    void controllerCheckerRunnable(ServiceLocator controllerLocator, Worker worker) {
        while (true) {
            ServiceLocations controllerLocations;
            long sleepTimeMillis = 1000L + ThreadLocalRandom.current().nextLong(-30L, 60L);
            try {
                controllerLocations = (ServiceLocations)controllerLocator.locate().get();
            }
            catch (Throwable e) {
                log.noStackTrace().warn(e, "Periodic fetch of controller location encountered an exception. Worker task [%s] will exit.", new Object[]{worker.id()});
                worker.controllerFailed();
                break;
            }
            if (controllerLocations.isClosed() || controllerLocations.getLocations().isEmpty()) {
                log.warn("Periodic fetch of controller location returned [%s]. Worker task [%s] will exit.", new Object[]{controllerLocations, worker.id()});
                worker.controllerFailed();
                break;
            }
            try {
                Thread.sleep(sleepTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public File tempDir() {
        return this.toolbox.getIndexingTmpDir();
    }

    @Override
    public ControllerClient makeControllerClient(String controllerId) {
        ServiceLocator locator = this.makeControllerLocator(controllerId);
        return new IndexerControllerClient(this.clientFactory.makeClient(controllerId, locator, (ServiceRetryPolicy)new SpecificTaskRetryPolicy(controllerId, (ServiceRetryPolicy)StandardRetryPolicy.unlimited())), this.jsonMapper(), (Closeable)locator);
    }

    @Override
    public WorkerClient makeWorkerClient() {
        return new IndexerWorkerClient(this.clientFactory, this.makeOverlordClient(), this.jsonMapper());
    }

    @Override
    public FrameContext frameContext(QueryDefinition queryDef, int stageNumber) {
        return new IndexerFrameContext(this, this.indexIO, this.dataSegmentProvider, WorkerMemoryParameters.createProductionInstanceForWorker(this.injector, queryDef, stageNumber));
    }

    @Override
    public int threadCount() {
        return this.processorBouncer().getMaxCount();
    }

    @Override
    public DruidNode selfNode() {
        return (DruidNode)this.injector.getInstance(Key.get(DruidNode.class, Self.class));
    }

    @Override
    public Bouncer processorBouncer() {
        return (Bouncer)this.injector.getInstance(Bouncer.class);
    }

    private synchronized OverlordClient makeOverlordClient() {
        if (this.overlordClient == null) {
            this.overlordClient = ((OverlordClient)this.injector.getInstance(OverlordClient.class)).withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        }
        return this.overlordClient;
    }

    private synchronized ServiceLocator makeControllerLocator(String controllerId) {
        if (this.controllerLocator == null) {
            this.controllerLocator = new SpecificTaskServiceLocator(controllerId, this.makeOverlordClient());
        }
        return this.controllerLocator;
    }
}

