/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.file.FrameFileHttpResponseHandler;
import org.apache.druid.frame.file.FrameFilePartialFetch;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SpecificTaskRetryPolicy;
import org.apache.druid.rpc.indexing.SpecificTaskServiceLocator;
import org.apache.druid.utils.CloseableUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class IndexerWorkerClient
implements WorkerClient {
    private final ServiceClientFactory clientFactory;
    private final OverlordClient overlordClient;
    private final ObjectMapper jsonMapper;
    @GuardedBy(value="clientMap")
    private final Map<String, Pair<ServiceClient, Closeable>> clientMap = new HashMap<String, Pair<ServiceClient, Closeable>>();
    private static final Logger log = new Logger(IndexerWorkerClient.class);

    public IndexerWorkerClient(ServiceClientFactory clientFactory, OverlordClient overlordClient, ObjectMapper jsonMapper) {
        this.clientFactory = clientFactory;
        this.overlordClient = overlordClient;
        this.jsonMapper = jsonMapper;
    }

    @Nonnull
    public static String getStagePartitionPath(StageId stageId, int partitionNumber) {
        return StringUtils.format((String)"/channels/%s/%d/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber(), partitionNumber});
    }

    @Override
    public ListenableFuture<Void> postWorkOrder(String workerTaskId, WorkOrder workOrder) {
        return this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.POST, "/workOrder").jsonContent(this.jsonMapper, (Object)workOrder), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<ClusterByStatisticsSnapshot> fetchClusterByStatisticsSnapshot(String workerTaskId, String queryId, int stageNumber) {
        String path = StringUtils.format((String)"/keyStatistics/%s/%d", (Object[])new Object[]{StringUtils.urlEncode((String)queryId), stageNumber});
        return FutureUtils.transform((ListenableFuture)this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.POST, path), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (TypeReference)new TypeReference<ClusterByStatisticsSnapshot>(){}));
    }

    @Override
    public ListenableFuture<ClusterByStatisticsSnapshot> fetchClusterByStatisticsSnapshotForTimeChunk(String workerTaskId, String queryId, int stageNumber, long timeChunk) {
        String path = StringUtils.format((String)"/keyStatisticsForTimeChunk/%s/%d/%d", (Object[])new Object[]{StringUtils.urlEncode((String)queryId), stageNumber, timeChunk});
        return FutureUtils.transform((ListenableFuture)this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.POST, path), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (TypeReference)new TypeReference<ClusterByStatisticsSnapshot>(){}));
    }

    @Override
    public ListenableFuture<Void> postResultPartitionBoundaries(String workerTaskId, StageId stageId, ClusterByPartitions partitionBoundaries) {
        String path = StringUtils.format((String)"/resultPartitionBoundaries/%s/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber()});
        return this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.POST, path).jsonContent(this.jsonMapper, (Object)partitionBoundaries), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<Void> postCleanupStage(String workerTaskId, StageId stageId) {
        String path = StringUtils.format((String)"/cleanupStage/%s/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber()});
        return this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.POST, path), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<Void> postFinish(String workerTaskId) {
        return this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.POST, "/finish"), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<CounterSnapshotsTree> getCounters(String workerTaskId) {
        return FutureUtils.transform((ListenableFuture)this.getClient(workerTaskId).asyncRequest(new RequestBuilder(HttpMethod.GET, "/counters"), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> this.deserialize((BytesFullResponseHolder)holder, (TypeReference)new TypeReference<CounterSnapshotsTree>(){}));
    }

    @Override
    public ListenableFuture<Boolean> fetchChannelData(String workerTaskId, StageId stageId, int partitionNumber, long offset, final ReadableByteChunksFrameChannel channel) {
        ServiceClient client = this.getClient(workerTaskId);
        String path = IndexerWorkerClient.getStagePartitionPath(stageId, partitionNumber);
        final SettableFuture retVal = SettableFuture.create();
        ListenableFuture clientFuture = client.asyncRequest(new RequestBuilder(HttpMethod.GET, StringUtils.format((String)"%s?offset=%d", (Object[])new Object[]{path, offset})).header("Accept-Encoding", "identity"), (HttpResponseHandler)new FrameFileHttpResponseHandler(channel));
        Futures.addCallback((ListenableFuture)clientFuture, (FutureCallback)new FutureCallback<FrameFilePartialFetch>(){

            public void onSuccess(FrameFilePartialFetch partialFetch) {
                if (partialFetch.isExceptionCaught()) {
                    log.noStackTrace().info(partialFetch.getExceptionCaught(), "Encountered exception while reading channel [%s]", new Object[]{channel.getId()});
                }
                partialFetch.backpressureFuture().addListener(() -> retVal.set((Object)partialFetch.isLastFetch()), (Executor)Execs.directExecutor());
            }

            public void onFailure(Throwable t) {
                retVal.setException(t);
            }
        });
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            try {
                List closeables = this.clientMap.values().stream().map(pair -> (Closeable)pair.rhs).collect(Collectors.toList());
                CloseableUtils.closeAll(closeables);
            }
            finally {
                this.clientMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceClient getClient(String workerTaskId) {
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            return (ServiceClient)this.clientMap.computeIfAbsent((String)workerTaskId, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getClient$4(java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/apache/druid/java/util/common/Pair;)((IndexerWorkerClient)this, (String)workerTaskId)).lhs;
        }
    }

    private <T> T deserialize(BytesFullResponseHolder bytesHolder, TypeReference<T> typeReference) {
        try {
            return (T)this.jsonMapper.readValue(bytesHolder.getContent(), typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ Pair lambda$getClient$4(String workerTaskId, String id) {
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(id, this.overlordClient);
        ServiceClient client = this.clientFactory.makeClient(id, (ServiceLocator)locator, (ServiceRetryPolicy)new SpecificTaskRetryPolicy(workerTaskId, (ServiceRetryPolicy)StandardRetryPolicy.unlimited()));
        return Pair.of((Object)client, (Object)locator);
    }
}

