/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.indexing.IndexerWorkerContext;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.DataSegmentPusher;

public class IndexerFrameContext
implements FrameContext {
    private final IndexerWorkerContext context;
    private final IndexIO indexIO;
    private final DataSegmentProvider dataSegmentProvider;
    private final WorkerMemoryParameters memoryParameters;

    public IndexerFrameContext(IndexerWorkerContext context, IndexIO indexIO, DataSegmentProvider dataSegmentProvider, WorkerMemoryParameters memoryParameters) {
        this.context = context;
        this.indexIO = indexIO;
        this.dataSegmentProvider = dataSegmentProvider;
        this.memoryParameters = memoryParameters;
    }

    @Override
    public JoinableFactory joinableFactory() {
        return (JoinableFactory)this.context.injector().getInstance(JoinableFactory.class);
    }

    @Override
    public GroupByStrategySelector groupByStrategySelector() {
        return (GroupByStrategySelector)this.context.injector().getInstance(GroupByStrategySelector.class);
    }

    @Override
    public RowIngestionMeters rowIngestionMeters() {
        return this.context.toolbox().getRowIngestionMetersFactory().createRowIngestionMeters();
    }

    @Override
    public DataSegmentProvider dataSegmentProvider() {
        return this.dataSegmentProvider;
    }

    @Override
    public File tempDir() {
        return this.context.tempDir();
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.context.jsonMapper();
    }

    @Override
    public IndexIO indexIO() {
        return this.indexIO;
    }

    @Override
    public File persistDir() {
        return this.context.toolbox().getPersistDir();
    }

    @Override
    public DataSegmentPusher segmentPusher() {
        return this.context.toolbox().getSegmentPusher();
    }

    @Override
    public IndexMergerV9 indexMerger() {
        return this.context.toolbox().getIndexMergerV9();
    }

    @Override
    public WorkerMemoryParameters memoryParameters() {
        return this.memoryParameters;
    }
}

