/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Map;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerManagerClient;
import org.apache.druid.msq.indexing.ControllerChatHandler;
import org.apache.druid.msq.indexing.IndexerWorkerClient;
import org.apache.druid.msq.indexing.IndexerWorkerManagerClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.server.DruidNode;

public class IndexerControllerContext
implements ControllerContext {
    private final TaskToolbox toolbox;
    private final Injector injector;
    private final ServiceClientFactory clientFactory;
    private final OverlordClient overlordClient;
    private final WorkerManagerClient workerManager;

    public IndexerControllerContext(TaskToolbox toolbox, Injector injector, ServiceClientFactory clientFactory, OverlordClient overlordClient) {
        this.toolbox = toolbox;
        this.injector = injector;
        this.clientFactory = clientFactory;
        this.overlordClient = overlordClient;
        this.workerManager = new IndexerWorkerManagerClient(overlordClient);
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.toolbox.getJsonMapper();
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public DruidNode selfNode() {
        return (DruidNode)this.injector.getInstance(Key.get(DruidNode.class, Self.class));
    }

    @Override
    public CoordinatorClient coordinatorClient() {
        return this.toolbox.getCoordinatorClient();
    }

    @Override
    public TaskActionClient taskActionClient() {
        return this.toolbox.getTaskActionClient();
    }

    @Override
    public WorkerClient taskClientFor(Controller controller) {
        return new IndexerWorkerClient(this.clientFactory, this.overlordClient, this.jsonMapper());
    }

    @Override
    public void registerController(Controller controller, Closer closer) {
        ControllerChatHandler chatHandler = new ControllerChatHandler(this.toolbox, controller);
        this.toolbox.getChatHandlerProvider().register(controller.id(), (ChatHandler)chatHandler, false);
        closer.register(() -> this.toolbox.getChatHandlerProvider().unregister(controller.id()));
    }

    @Override
    public WorkerManagerClient workerManager() {
        return this.workerManager;
    }

    @Override
    public void writeReports(String controllerTaskId, Map<String, TaskReport> reports) {
        this.toolbox.getTaskReportFileWriter().write(controllerTaskId, reports);
    }
}

