/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.indexing.MSQTaskList;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class IndexerControllerClient
implements ControllerClient {
    private final ServiceClient serviceClient;
    private final ObjectMapper jsonMapper;
    private final Closeable baggage;

    public IndexerControllerClient(ServiceClient serviceClient, ObjectMapper jsonMapper, Closeable baggage) {
        this.serviceClient = serviceClient;
        this.jsonMapper = jsonMapper;
        this.baggage = baggage;
    }

    @Override
    public void postPartialKeyStatistics(StageId stageId, int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) throws IOException {
        String path = StringUtils.format((String)"/partialKeyStatisticsInformation/%s/%d/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber(), workerNumber});
        this.doRequest(new RequestBuilder(HttpMethod.POST, path).jsonContent(this.jsonMapper, (Object)partialKeyStatisticsInformation), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public void postCounters(CounterSnapshotsTree snapshotsTree) throws IOException {
        this.doRequest(new RequestBuilder(HttpMethod.POST, "/counters").jsonContent(this.jsonMapper, (Object)snapshotsTree), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public void postResultsComplete(StageId stageId, int workerNumber, @Nullable Object resultObject) throws IOException {
        String path = StringUtils.format((String)"/resultsComplete/%s/%s/%d", (Object[])new Object[]{StringUtils.urlEncode((String)stageId.getQueryId()), stageId.getStageNumber(), workerNumber});
        this.doRequest(new RequestBuilder(HttpMethod.POST, path).jsonContent(this.jsonMapper, resultObject), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public void postWorkerError(String workerId, MSQErrorReport errorWrapper) throws IOException {
        String path = StringUtils.format((String)"/workerError/%s", (Object[])new Object[]{StringUtils.urlEncode((String)workerId)});
        this.doRequest(new RequestBuilder(HttpMethod.POST, path).jsonContent(this.jsonMapper, (Object)errorWrapper), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public void postWorkerWarning(List<MSQErrorReport> MSQErrorReports) throws IOException {
        String path = "/workerWarning";
        this.doRequest(new RequestBuilder(HttpMethod.POST, "/workerWarning").jsonContent(this.jsonMapper, MSQErrorReports), (HttpResponseHandler)IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public List<String> getTaskList() throws IOException {
        BytesFullResponseHolder retVal = (BytesFullResponseHolder)this.doRequest(new RequestBuilder(HttpMethod.GET, "/taskList"), (HttpResponseHandler)new BytesFullResponseHandler());
        MSQTaskList taskList = (MSQTaskList)this.jsonMapper.readValue(retVal.getContent(), MSQTaskList.class);
        return taskList.getTaskIds();
    }

    @Override
    public void close() {
        try {
            this.baggage.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <IntermediateType, FinalType> FinalType doRequest(RequestBuilder requestBuilder, HttpResponseHandler<IntermediateType, FinalType> handler) throws IOException {
        try {
            return (FinalType)FutureUtils.get((ListenableFuture)this.serviceClient.asyncRequest(requestBuilder, handler), (boolean)true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }
}

