/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.helpers.OverlordHelper;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.DurableStorageCleanerConfig;
import org.apache.druid.msq.shuffle.DurableStorageUtils;
import org.apache.druid.storage.StorageConnector;
import org.joda.time.Duration;

public class DurableStorageCleaner
implements OverlordHelper {
    private static final Logger LOG = new Logger(DurableStorageCleaner.class);
    private final DurableStorageCleanerConfig config;
    private final StorageConnector storageConnector;
    private final Provider<TaskMaster> taskMasterProvider;

    @Inject
    public DurableStorageCleaner(DurableStorageCleanerConfig config, @MultiStageQuery StorageConnector storageConnector, @JacksonInject Provider<TaskMaster> taskMasterProvider) {
        this.config = config;
        this.storageConnector = storageConnector;
        this.taskMasterProvider = taskMasterProvider;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public void schedule(ScheduledExecutorService exec) {
        LOG.info("Starting the DurableStorageCleaner with the config [%s]", new Object[]{this.config});
        ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)exec, (Duration)Duration.standardSeconds((long)this.config.getDelaySeconds()), (Duration)Duration.standardSeconds((long)this.config.getDelaySeconds()), () -> {
            try {
                LOG.info("Starting the run of durable storage cleaner", new Object[0]);
                Optional taskRunnerOptional = ((TaskMaster)this.taskMasterProvider.get()).getTaskRunner();
                if (!taskRunnerOptional.isPresent()) {
                    LOG.info("Durable storage cleaner not running since the node is not the leader", new Object[0]);
                    return;
                }
                TaskRunner taskRunner = (TaskRunner)taskRunnerOptional.get();
                HashSet allDirectories = new HashSet(this.storageConnector.listDir("/"));
                Set runningTaskIds = taskRunner.getRunningTasks().stream().map(TaskRunnerWorkItem::getTaskId).map(DurableStorageUtils::getControllerDirectory).collect(Collectors.toSet());
                Sets.SetView unknownDirectories = Sets.difference(allDirectories, runningTaskIds);
                LOG.info("Following directories do not have a corresponding MSQ task associated with it:\n%s\nThese will get cleaned up.", new Object[]{unknownDirectories});
                for (String unknownDirectory : unknownDirectories) {
                    this.storageConnector.deleteRecursively(unknownDirectory);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while running the scheduled durable storage cleanup helper", e);
            }
        });
    }
}

