/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.indexing.MSQDestination;
import org.joda.time.Interval;

public class DataSourceMSQDestination
implements MSQDestination {
    static final String TYPE = "dataSource";
    private final String dataSource;
    private final Granularity segmentGranularity;
    private final List<String> segmentSortOrder;
    @Nullable
    private final List<Interval> replaceTimeChunks;

    @JsonCreator
    public DataSourceMSQDestination(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="segmentSortOrder") @Nullable List<String> segmentSortOrder, @JsonProperty(value="replaceTimeChunks") @Nullable List<Interval> replaceTimeChunks) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)TYPE);
        this.segmentGranularity = (Granularity)Preconditions.checkNotNull((Object)segmentGranularity, (Object)"segmentGranularity");
        this.segmentSortOrder = segmentSortOrder != null ? segmentSortOrder : Collections.emptyList();
        this.replaceTimeChunks = replaceTimeChunks;
        if (replaceTimeChunks != null) {
            if (replaceTimeChunks.isEmpty()) {
                throw new IAE("replaceTimeChunks must be null or nonempty; cannot be empty", new Object[0]);
            }
            for (Interval interval : replaceTimeChunks) {
                boolean endIsAligned;
                if (Intervals.ETERNITY.equals((Object)interval)) continue;
                boolean startIsAligned = segmentGranularity.bucketStart(interval.getStart()).equals((Object)interval.getStart());
                boolean bl = endIsAligned = segmentGranularity.bucketStart(interval.getEnd()).equals((Object)interval.getEnd()) || segmentGranularity.increment(segmentGranularity.bucketStart(interval.getEnd())).equals((Object)interval.getEnd());
                if (startIsAligned && endIsAligned) continue;
                throw new IAE("Time chunk [%s] provided in replaceTimeChunks is not aligned with segmentGranularity [%s]", new Object[]{interval, segmentGranularity});
            }
        }
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getSegmentSortOrder() {
        return this.segmentSortOrder;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Interval> getReplaceTimeChunks() {
        return this.replaceTimeChunks;
    }

    public boolean isReplaceTimeChunks() {
        return this.replaceTimeChunks != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceMSQDestination that = (DataSourceMSQDestination)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.segmentGranularity, that.segmentGranularity) && Objects.equals(this.segmentSortOrder, that.segmentSortOrder) && Objects.equals(this.replaceTimeChunks, that.replaceTimeChunks);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.segmentGranularity, this.segmentSortOrder, this.replaceTimeChunks);
    }

    public String toString() {
        return "DataSourceMSQDestination{dataSource='" + this.dataSource + '\'' + ", segmentGranularity=" + this.segmentGranularity + ", segmentSortOrder=" + this.segmentSortOrder + ", replaceTimeChunks=" + this.replaceTimeChunks + '}';
    }
}

