/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.msq.counters.ChannelCounters;

public class CountingWritableFrameChannel
implements WritableFrameChannel {
    private final WritableFrameChannel baseChannel;
    private final ChannelCounters channelCounters;
    private final int partitionNumber;

    public CountingWritableFrameChannel(WritableFrameChannel baseChannel, ChannelCounters channelCounters, int partitionNumber) {
        this.baseChannel = baseChannel;
        this.channelCounters = channelCounters;
        this.partitionNumber = partitionNumber;
    }

    public void write(FrameWithPartition frame) throws IOException {
        this.baseChannel.write(frame);
        this.channelCounters.addFrame(this.partitionNumber, frame.frame());
    }

    public void fail(@Nullable Throwable cause) throws IOException {
        this.baseChannel.fail(cause);
    }

    public void close() throws IOException {
        this.baseChannel.close();
    }

    public ListenableFuture<?> writabilityFuture() {
        return this.baseChannel.writabilityFuture();
    }
}

