/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQTaskList;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.realtime.firehose.ChatHandlers;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;

public class ControllerChatHandler
implements ChatHandler {
    private final Controller controller;
    private final MSQControllerTask task;
    private final TaskToolbox toolbox;

    public ControllerChatHandler(TaskToolbox toolbox, Controller controller) {
        this.controller = controller;
        this.task = controller.task();
        this.toolbox = toolbox;
    }

    @POST
    @Path(value="/partialKeyStatisticsInformation/{queryId}/{stageNumber}/{workerNumber}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostPartialKeyStatistics(Object partialKeyStatisticsObject, @PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="workerNumber") int workerNumber, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.controller.updatePartialKeyStatisticsInformation(stageNumber, workerNumber, partialKeyStatisticsObject);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/workerError/{taskId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostWorkerError(MSQErrorReport errorReport, @PathParam(value="taskId") String taskId, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.controller.workerError(errorReport);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/workerWarning")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostWorkerWarning(List<MSQErrorReport> errorReport, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.controller.workerWarning(errorReport);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/counters")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostCounters(CounterSnapshotsTree snapshotsTree, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.controller.updateCounters(snapshotsTree);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/resultsComplete/{queryId}/{stageNumber}/{workerNumber}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpPostResultsComplete(Object resultObject, @PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="workerNumber") int workerNumber, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.controller.resultsComplete(queryId, stageNumber, workerNumber, resultObject);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/taskList")
    @Produces(value={"application/json"})
    public Response httpGetTaskList(@Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        return Response.ok((Object)new MSQTaskList(this.controller.getTaskIds())).build();
    }

    @GET
    @Path(value="/liveReports")
    @Produces(value={"application/json"})
    public Response httpGetLiveReports(@Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        Map<String, TaskReport> reports = this.controller.liveReports();
        if (reports == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(reports).build();
    }
}

