/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.indexing.ColumnMapping;
import org.apache.druid.segment.column.RowSignature;

public class ColumnMappings {
    private final List<ColumnMapping> mappings;
    private final Map<String, String> outputToQueryColumnMap;
    private final Map<String, List<String>> queryToOutputColumnsMap;

    @JsonCreator
    public ColumnMappings(List<ColumnMapping> mappings) {
        this.mappings = ColumnMappings.validateNoDuplicateOutputColumns((List)Preconditions.checkNotNull(mappings, (Object)"mappings"));
        this.outputToQueryColumnMap = new HashMap<String, String>();
        this.queryToOutputColumnsMap = new HashMap<String, List<String>>();
        for (ColumnMapping mapping : mappings) {
            this.outputToQueryColumnMap.put(mapping.getOutputColumn(), mapping.getQueryColumn());
            this.queryToOutputColumnsMap.computeIfAbsent(mapping.getQueryColumn(), k -> new ArrayList()).add(mapping.getOutputColumn());
        }
    }

    public static ColumnMappings identity(RowSignature signature) {
        return new ColumnMappings(signature.getColumnNames().stream().map(column -> new ColumnMapping((String)column, (String)column)).collect(Collectors.toList()));
    }

    public List<String> getOutputColumnNames() {
        return this.mappings.stream().map(ColumnMapping::getOutputColumn).collect(Collectors.toList());
    }

    public boolean hasOutputColumn(String columnName) {
        return this.outputToQueryColumnMap.containsKey(columnName);
    }

    public String getQueryColumnForOutputColumn(String outputColumn) {
        String queryColumn = this.outputToQueryColumnMap.get(outputColumn);
        if (queryColumn != null) {
            return queryColumn;
        }
        throw new IAE("No such output column [%s]", new Object[]{outputColumn});
    }

    public List<String> getOutputColumnsForQueryColumn(String queryColumn) {
        List<String> outputColumns = this.queryToOutputColumnsMap.get(queryColumn);
        if (outputColumns != null) {
            return outputColumns;
        }
        return Collections.emptyList();
    }

    @JsonValue
    public List<ColumnMapping> getMappings() {
        return this.mappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMappings that = (ColumnMappings)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public String toString() {
        return "ColumnMappings{mappings=" + this.mappings + '}';
    }

    private static List<ColumnMapping> validateNoDuplicateOutputColumns(List<ColumnMapping> mappings) {
        HashSet<String> encountered = new HashSet<String>();
        for (ColumnMapping mapping : mappings) {
            if (encountered.add(mapping.getOutputColumn())) continue;
            throw new ISE("Duplicate output column [%s]", new Object[]{mapping.getOutputColumn()});
        }
        return mappings;
    }
}

