/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.guice;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.msq.rpc.CoordinatorServiceClient;
import org.apache.druid.msq.rpc.CoordinatorServiceClientImpl;
import org.apache.druid.rpc.DiscoveryServiceLocator;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;

public class MSQServiceClientModule
implements DruidModule {
    private static final int COORDINATOR_ATTEMPTS = 6;

    public List<? extends Module> getJacksonModules() {
        return Collections.emptyList();
    }

    public void configure(Binder binder) {
    }

    @Provides
    @ManageLifecycle
    @Coordinator
    public ServiceLocator makeCoordinatorServiceLocator(DruidNodeDiscoveryProvider discoveryProvider) {
        return new DiscoveryServiceLocator(discoveryProvider, NodeRole.COORDINATOR);
    }

    @Provides
    public CoordinatorServiceClient makeCoordinatorServiceClient(@Json ObjectMapper jsonMapper, @EscalatedGlobal ServiceClientFactory clientFactory, @Coordinator ServiceLocator serviceLocator) {
        return new CoordinatorServiceClientImpl(clientFactory.makeClient(NodeRole.COORDINATOR.getJsonName(), serviceLocator, (ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(6L).build()), jsonMapper);
    }
}

