/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.guice;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.overlord.helpers.OverlordHelper;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.DurableStorageCleaner;
import org.apache.druid.msq.indexing.DurableStorageCleanerConfig;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.StorageConnectorProvider;

public class MSQDurableStorageModule
implements DruidModule {
    public static final String MSQ_INTERMEDIATE_STORAGE_PREFIX = String.join((CharSequence)".", "druid.msq", "intermediate.storage");
    public static final String MSQ_INTERMEDIATE_STORAGE_ENABLED = String.join((CharSequence)".", MSQ_INTERMEDIATE_STORAGE_PREFIX, "enable");
    private Properties properties;
    private Set<NodeRole> nodeRoles;

    @Inject
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Inject
    public void setNodeRoles(@Self Set<NodeRole> nodeRoles) {
        this.nodeRoles = nodeRoles;
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of();
    }

    public void configure(Binder binder) {
        if (this.isDurableShuffleStorageEnabled()) {
            JsonConfigProvider.bind((Binder)binder, (String)MSQ_INTERMEDIATE_STORAGE_PREFIX, StorageConnectorProvider.class, MultiStageQuery.class);
            binder.bind(Key.get(StorageConnector.class, MultiStageQuery.class)).toProvider(Key.get(StorageConnectorProvider.class, MultiStageQuery.class)).in(LazySingleton.class);
            if (this.nodeRoles.contains(NodeRole.OVERLORD)) {
                JsonConfigProvider.bind((Binder)binder, (String)String.join((CharSequence)".", MSQ_INTERMEDIATE_STORAGE_PREFIX, "cleaner"), DurableStorageCleanerConfig.class);
                Multibinder.newSetBinder((Binder)binder, OverlordHelper.class).addBinding().to(DurableStorageCleaner.class);
            }
        }
    }

    private boolean isDurableShuffleStorageEnabled() {
        return Boolean.parseBoolean((String)this.properties.getOrDefault((Object)MSQ_INTERMEDIATE_STORAGE_ENABLED, "false"));
    }
}

