/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ReadableFileFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.processor.BlockingQueueOutputChannelFactory;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.FileOutputChannelFactory;
import org.apache.druid.frame.processor.FrameChannelMuxer;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.SuperSorter;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.ControllerClient;
import org.apache.druid.msq.exec.ExceptionWrappingWorkerClient;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.indexing.CountingOutputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelsImpl;
import org.apache.druid.msq.indexing.KeyStatisticsCollectionProcessor;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQWarningReportLimiterPublisher;
import org.apache.druid.msq.indexing.error.MSQWarningReportPublisher;
import org.apache.druid.msq.indexing.error.MSQWarningReportSimplePublisher;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.InputSlices;
import org.apache.druid.msq.input.MapInputSliceReader;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.NilInputSliceReader;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.external.ExternalInputSliceReader;
import org.apache.druid.msq.input.stage.InputChannels;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSliceReader;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.SegmentsInputSliceReader;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.FrameProcessorFactory;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.StagePartition;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.worker.WorkerStageKernel;
import org.apache.druid.msq.kernel.worker.WorkerStagePhase;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.msq.shuffle.DurableStorageInputChannelFactory;
import org.apache.druid.msq.shuffle.DurableStorageOutputChannelFactory;
import org.apache.druid.msq.shuffle.DurableStorageUtils;
import org.apache.druid.msq.shuffle.WorkerInputChannelFactory;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;
import org.apache.druid.msq.util.DecoratedExecutorService;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.PrioritizedCallable;
import org.apache.druid.query.PrioritizedRunnable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.server.DruidNode;

public class WorkerImpl
implements Worker {
    private static final Logger log = new Logger(WorkerImpl.class);
    private final MSQWorkerTask task;
    private final WorkerContext context;
    private final DruidNode selfDruidNode;
    private final Bouncer processorBouncer;
    private final BlockingQueue<Consumer<KernelHolder>> kernelManipulationQueue = new LinkedBlockingDeque<Consumer<KernelHolder>>();
    private final ConcurrentHashMap<StageId, ConcurrentHashMap<Integer, ReadableFrameChannel>> stageOutputs = new ConcurrentHashMap();
    private final ConcurrentHashMap<StageId, CounterTracker> stageCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<StageId, WorkerStageKernel> stageKernelMap = new ConcurrentHashMap();
    private final boolean durableStageStorageEnabled;
    private volatile ControllerClient controllerClient;
    private volatile WorkerClient workerClient;
    private volatile boolean controllerAlive = true;

    public WorkerImpl(MSQWorkerTask task, WorkerContext context) {
        this.task = task;
        this.context = context;
        this.selfDruidNode = context.selfNode();
        this.processorBouncer = context.processorBouncer();
        this.durableStageStorageEnabled = MultiStageQueryContext.isDurableStorageEnabled(QueryContext.of((Map)task.getContext()));
    }

    @Override
    public String id() {
        return this.task.getId();
    }

    @Override
    public MSQWorkerTask task() {
        return this.task;
    }

    @Override
    public TaskStatus run() throws Exception {
        try (Closer closer = Closer.create();){
            Optional<MSQErrorReport> maybeErrorReport;
            try {
                maybeErrorReport = this.runTask(closer);
            }
            catch (Throwable e) {
                maybeErrorReport = Optional.of(MSQErrorReport.fromException(this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode), null, e));
            }
            if (maybeErrorReport.isPresent()) {
                MSQErrorReport errorReport = maybeErrorReport.get();
                String errorLogMessage = MSQTasks.errorReportToLogMessage(errorReport);
                log.warn(errorLogMessage, new Object[0]);
                closer.register(() -> {
                    if (this.controllerAlive && this.controllerClient != null && this.selfDruidNode != null) {
                        this.controllerClient.postWorkerError(this.id(), errorReport);
                    }
                });
                TaskStatus taskStatus = TaskStatus.failure((String)this.id(), (String)errorReport.getFault().getCodeWithMessage());
                return taskStatus;
            }
            TaskStatus taskStatus = TaskStatus.success((String)this.id());
            return taskStatus;
        }
    }

    public Optional<MSQErrorReport> runTask(Closer closer) throws Exception {
        this.controllerClient = this.context.makeControllerClient(this.task.getControllerTaskId());
        closer.register(this.controllerClient::close);
        this.context.registerWorker(this, closer);
        this.workerClient = new ExceptionWrappingWorkerClient(this.context.makeWorkerClient());
        closer.register(this.workerClient::close);
        KernelHolder kernelHolder = new KernelHolder();
        String cancellationId = this.id();
        FrameProcessorExecutor workerExec = new FrameProcessorExecutor(this.makeProcessingPool());
        closer.register(() -> {
            for (StageId stageId : this.stageOutputs.keySet()) {
                this.cleanStageOutput(stageId);
            }
        });
        closer.register(() -> {
            try {
                workerExec.cancel(cancellationId);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        long maxAllowedParseExceptions = Long.parseLong(((Object)this.task.getContext().getOrDefault("maxParseExceptions", Long.MAX_VALUE)).toString());
        long maxVerboseParseExceptions = maxAllowedParseExceptions == -1L ? 5L : Math.min(maxAllowedParseExceptions, 5L);
        ImmutableSet criticalWarningCodes = maxAllowedParseExceptions == 0L ? ImmutableSet.of((Object)"CannotParseExternalData") : ImmutableSet.of();
        MSQWarningReportLimiterPublisher msqWarningReportPublisher = new MSQWarningReportLimiterPublisher(new MSQWarningReportSimplePublisher(this.id(), this.controllerClient, this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode)), 10L, (Map<String, Long>)ImmutableMap.of((Object)"CannotParseExternalData", (Object)maxVerboseParseExceptions), (Set<String>)criticalWarningCodes, this.controllerClient, this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode));
        closer.register((Closeable)msqWarningReportPublisher);
        HashMap<StageId, SettableFuture<ClusterByPartitions>> partitionBoundariesFutureMap = new HashMap<StageId, SettableFuture<ClusterByPartitions>>();
        HashMap<StageId, FrameContext> stageFrameContexts = new HashMap<StageId, FrameContext>();
        while (!kernelHolder.isDone()) {
            Consumer<KernelHolder> nextCommand;
            boolean didSomething = false;
            for (WorkerStageKernel kernel : kernelHolder.getStageKernelMap().values()) {
                StageDefinition stageDefinition = kernel.getStageDefinition();
                if (kernel.getPhase() == WorkerStagePhase.NEW) {
                    log.debug("New work order: %s", new Object[]{this.context.jsonMapper().writeValueAsString((Object)kernel.getWorkOrder())});
                    InputChannelFactory inputChannelFactory = this.makeBaseInputChannelFactory(closer);
                    for (StageDefinition stageDef : kernel.getWorkOrder().getQueryDefinition().getStageDefinitions()) {
                        stageFrameContexts.computeIfAbsent(stageDef.getId(), stageId -> this.context.frameContext(kernel.getWorkOrder().getQueryDefinition(), stageId.getStageNumber()));
                    }
                    kernel.startReading();
                    SettableFuture<ClusterByPartitions> partitionBoundariesFuture = this.startWorkOrder(kernel, inputChannelFactory, this.stageCounters.computeIfAbsent(stageDefinition.getId(), ignored -> new CounterTracker()), workerExec, cancellationId, this.context.threadCount(), (FrameContext)stageFrameContexts.get(stageDefinition.getId()), msqWarningReportPublisher);
                    if (partitionBoundariesFuture != null && partitionBoundariesFutureMap.put(stageDefinition.getId(), partitionBoundariesFuture) != null) {
                        throw new ISE("Work order collision for stage [%s]", new Object[]{stageDefinition.getId()});
                    }
                    didSomething = true;
                    WorkerImpl.logKernelStatus(kernelHolder.getStageKernelMap().values());
                }
                if (kernel.getPhase() == WorkerStagePhase.READING_INPUT && kernel.hasResultKeyStatisticsSnapshot()) {
                    if (this.controllerAlive) {
                        PartialKeyStatisticsInformation partialKeyStatisticsInformation = kernel.getResultKeyStatisticsSnapshot().partialKeyStatistics();
                        this.controllerClient.postPartialKeyStatistics(stageDefinition.getId(), kernel.getWorkOrder().getWorkerNumber(), partialKeyStatisticsInformation);
                    }
                    kernel.startPreshuffleWaitingForResultPartitionBoundaries();
                    didSomething = true;
                    WorkerImpl.logKernelStatus(kernelHolder.getStageKernelMap().values());
                }
                WorkerImpl.logKernelStatus(kernelHolder.getStageKernelMap().values());
                if (kernel.getPhase() == WorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES && kernel.hasResultPartitionBoundaries()) {
                    ((SettableFuture)partitionBoundariesFutureMap.get(stageDefinition.getId())).set((Object)kernel.getResultPartitionBoundaries());
                    kernel.startPreshuffleWritingOutput();
                    didSomething = true;
                    WorkerImpl.logKernelStatus(kernelHolder.getStageKernelMap().values());
                }
                if (kernel.getPhase() == WorkerStagePhase.RESULTS_READY && kernel.addPostedResultsComplete((Pair<StageId, Integer>)Pair.of((Object)stageDefinition.getId(), (Object)kernel.getWorkOrder().getWorkerNumber())) && this.controllerAlive) {
                    this.controllerClient.postResultsComplete(stageDefinition.getId(), kernel.getWorkOrder().getWorkerNumber(), kernel.getResultObject());
                }
                if (kernel.getPhase() != WorkerStagePhase.FAILED) continue;
                return Optional.of(MSQErrorReport.fromException(this.id(), MSQTasks.getHostFromSelfNode(this.selfDruidNode), stageDefinition.getId().getStageNumber(), kernel.getException()));
            }
            if (didSomething || kernelHolder.isDone()) continue;
            do {
                this.postCountersToController();
            } while ((nextCommand = this.kernelManipulationQueue.poll(5L, TimeUnit.SECONDS)) == null);
            nextCommand.accept(kernelHolder);
            WorkerImpl.logKernelStatus(kernelHolder.getStageKernelMap().values());
        }
        return Optional.empty();
    }

    @Override
    public void stopGracefully() {
        this.kernelManipulationQueue.add(kernel -> {
            throw new MSQException(CanceledFault.INSTANCE);
        });
    }

    @Override
    public void controllerFailed() {
        this.controllerAlive = false;
        this.stopGracefully();
    }

    @Override
    public InputStream readChannel(String queryId, int stageNumber, int partitionNumber, long offset) throws IOException {
        StageId stageId = new StageId(queryId, stageNumber);
        StagePartition stagePartition = new StagePartition(stageId, partitionNumber);
        ConcurrentHashMap<Integer, ReadableFrameChannel> partitionOutputsForStage = this.stageOutputs.get(stageId);
        if (partitionOutputsForStage == null) {
            return null;
        }
        ReadableFrameChannel channel = partitionOutputsForStage.get(partitionNumber);
        if (channel == null) {
            return null;
        }
        if (channel instanceof ReadableNilFrameChannel) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FrameFileWriter.open((WritableByteChannel)Channels.newChannel(baos), null).close();
            ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
            in.skip(offset);
            return in;
        }
        if (channel instanceof ReadableFileFrameChannel) {
            try (FrameFile frameFile = ((ReadableFileFrameChannel)channel).newFrameFileReference();){
                RandomAccessFile randomAccessFile = new RandomAccessFile(frameFile.file(), "r");
                if (offset >= randomAccessFile.length()) {
                    randomAccessFile.close();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteArrays.EMPTY_ARRAY);
                    return byteArrayInputStream;
                }
                randomAccessFile.seek(offset);
                InputStream inputStream = Channels.newInputStream(randomAccessFile.getChannel());
                return inputStream;
            }
        }
        String errorMsg = StringUtils.format((String)"Returned server error to client because channel for [%s] is not nil or file-based (class = %s)", (Object[])new Object[]{stagePartition, channel.getClass().getName()});
        log.error(StringUtils.encodeForFormat((String)errorMsg), new Object[0]);
        throw new IOException(errorMsg);
    }

    @Override
    public void postWorkOrder(WorkOrder workOrder) {
        if (this.task.getWorkerNumber() != workOrder.getWorkerNumber()) {
            throw new ISE("Worker number mismatch: expected [%d]", new Object[]{this.task.getWorkerNumber()});
        }
        this.kernelManipulationQueue.add(kernelHolder -> kernelHolder.getStageKernelMap().computeIfAbsent(workOrder.getStageDefinition().getId(), ignored -> WorkerStageKernel.create(workOrder)));
    }

    @Override
    public boolean postResultPartitionBoundaries(ClusterByPartitions stagePartitionBoundaries, String queryId, int stageNumber) {
        StageId stageId = new StageId(queryId, stageNumber);
        this.kernelManipulationQueue.add(kernelHolder -> {
            WorkerStageKernel stageKernel = kernelHolder.getStageKernelMap().get(stageId);
            if (stageKernel != null) {
                stageKernel.setResultPartitionBoundaries(stagePartitionBoundaries);
            } else {
                log.warn("Ignored result partition boundaries call for unknown stage [%s]", new Object[]{stageId});
            }
        });
        return true;
    }

    @Override
    public void postCleanupStage(StageId stageId) {
        log.info("Cleanup order for stage: [%s] received", new Object[]{stageId});
        this.kernelManipulationQueue.add(holder -> {
            this.cleanStageOutput(stageId);
            holder.getStageKernelMap().get(stageId).setStageFinished();
        });
    }

    @Override
    public void postFinish() {
        this.kernelManipulationQueue.add(KernelHolder::setDone);
    }

    @Override
    public ClusterByStatisticsSnapshot fetchStatisticsSnapshot(StageId stageId) {
        if (this.stageKernelMap.get(stageId) == null) {
            throw new ISE("Requested statistics snapshot for non-existent stageId %s.", new Object[]{stageId});
        }
        if (this.stageKernelMap.get(stageId).getResultKeyStatisticsSnapshot() == null) {
            throw new ISE("Requested statistics snapshot is not generated yet for stageId[%s]", new Object[]{stageId});
        }
        return this.stageKernelMap.get(stageId).getResultKeyStatisticsSnapshot();
    }

    @Override
    public ClusterByStatisticsSnapshot fetchStatisticsSnapshotForTimeChunk(StageId stageId, long timeChunk) {
        if (this.stageKernelMap.get(stageId) == null) {
            throw new ISE("Requested statistics snapshot for non-existent stageId[%s].", new Object[]{stageId});
        }
        if (this.stageKernelMap.get(stageId).getResultKeyStatisticsSnapshot() == null) {
            throw new ISE("Requested statistics snapshot is not generated yet for stageId[%s]", new Object[]{stageId});
        }
        return this.stageKernelMap.get(stageId).getResultKeyStatisticsSnapshot().getSnapshotForTimeChunk(timeChunk);
    }

    @Override
    public CounterSnapshotsTree getCounters() {
        CounterSnapshotsTree retVal = new CounterSnapshotsTree();
        for (Map.Entry<StageId, CounterTracker> entry : this.stageCounters.entrySet()) {
            retVal.put(entry.getKey().getStageNumber(), this.task().getWorkerNumber(), entry.getValue().snapshot());
        }
        return retVal;
    }

    private InputChannelFactory makeBaseInputChannelFactory(Closer closer) {
        Supplier<List<String>> workerTaskList = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> {
            try {
                return this.controllerClient.getTaskList();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).get();
        if (this.durableStageStorageEnabled) {
            return DurableStorageInputChannelFactory.createStandardImplementation(this.task.getControllerTaskId(), MSQTasks.makeStorageConnector(this.context.injector()), closer);
        }
        return new WorkerOrLocalInputChannelFactory(workerTaskList);
    }

    private OutputChannelFactory makeStageOutputChannelFactory(FrameContext frameContext, int stageNumber) {
        int frameSize = frameContext.memoryParameters().getStandardFrameSize();
        if (this.durableStageStorageEnabled) {
            return DurableStorageOutputChannelFactory.createStandardImplementation(this.task.getControllerTaskId(), this.task().getWorkerNumber(), stageNumber, this.task().getId(), frameSize, MSQTasks.makeStorageConnector(this.context.injector()));
        }
        File fileChannelDirectory = new File(this.context.tempDir(), StringUtils.format((String)"output_stage_%06d", (Object[])new Object[]{stageNumber}));
        return new FileOutputChannelFactory(fileChannelDirectory, frameSize);
    }

    private ListeningExecutorService makeProcessingPool() {
        QueryProcessingPool queryProcessingPool = (QueryProcessingPool)this.context.injector().getInstance(QueryProcessingPool.class);
        boolean priority = false;
        return new DecoratedExecutorService((ListeningExecutorService)queryProcessingPool, new DecoratedExecutorService.Decorator(){

            @Override
            public <T> Callable<T> decorateCallable(final Callable<T> callable) {
                return new PrioritizedCallable<T>(){

                    public int getPriority() {
                        return 0;
                    }

                    public T call() throws Exception {
                        return callable.call();
                    }
                };
            }

            @Override
            public Runnable decorateRunnable(final Runnable runnable) {
                return new PrioritizedRunnable(){

                    public int getPriority() {
                        return 0;
                    }

                    public void run() {
                        runnable.run();
                    }
                };
            }
        });
    }

    private void postCountersToController() throws IOException {
        CounterSnapshotsTree snapshotsTree = this.getCounters();
        if (this.controllerAlive && !snapshotsTree.isEmpty()) {
            this.controllerClient.postCounters(snapshotsTree);
        }
    }

    private void cleanStageOutput(StageId stageId) {
        ConcurrentHashMap<Integer, ReadableFrameChannel> partitionOutputsForStage = this.stageOutputs.remove(stageId);
        if (partitionOutputsForStage == null) {
            return;
        }
        Iterator iterator = ((ConcurrentHashMap.KeySetView)partitionOutputsForStage.keySet()).iterator();
        while (iterator.hasNext()) {
            int partition = (Integer)iterator.next();
            ReadableFrameChannel output = partitionOutputsForStage.remove(partition);
            if (output == null) continue;
            output.close();
            if (!this.durableStageStorageEnabled) continue;
            String folderName = DurableStorageUtils.getTaskIdOutputsFolderName(this.task.getControllerTaskId(), stageId.getStageNumber(), this.task.getWorkerNumber(), this.task.getId());
            try {
                MSQTasks.makeStorageConnector(this.context.injector()).deleteRecursively(folderName);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Error while cleaning up folder at path " + folderName, new Object[0]);
            }
        }
    }

    @Nullable
    private SettableFuture<ClusterByPartitions> startWorkOrder(WorkerStageKernel kernel, InputChannelFactory inputChannelFactory, CounterTracker counters, FrameProcessorExecutor exec, String cancellationId, int parallelism, final FrameContext frameContext, MSQWarningReportPublisher MSQWarningReportPublisher2) throws IOException {
        ListenableFuture outputChannelsFuture;
        Object stagePartitionBoundariesFuture;
        WorkOrder workOrder = kernel.getWorkOrder();
        int workerNumber = workOrder.getWorkerNumber();
        final StageDefinition stageDef = workOrder.getStageDefinition();
        InputChannelsImpl inputChannels = new InputChannelsImpl(workOrder.getQueryDefinition(), InputSlices.allReadablePartitions(workOrder.getInputs()), inputChannelFactory, () -> ArenaMemoryAllocator.createOnHeap((int)frameContext.memoryParameters().getStandardFrameSize()), exec, cancellationId);
        InputSliceReader inputSliceReader = WorkerImpl.makeInputSliceReader(workOrder.getQueryDefinition(), inputChannels, frameContext.tempDir(), frameContext.dataSegmentProvider());
        Object workerOutputChannelFactory = stageDef.doesShuffle() ? new BlockingQueueOutputChannelFactory(frameContext.memoryParameters().getLargeFrameSize()) : this.makeStageOutputChannelFactory(frameContext, stageDef.getStageNumber());
        ResultAndChannels workerResultAndOutputChannels = WorkerImpl.makeAndRunWorkers(workerNumber, workOrder.getStageDefinition().getProcessorFactory(), workOrder.getExtraInfo(), new CountingOutputChannelFactory((OutputChannelFactory)workerOutputChannelFactory, counters.channel(CounterNames.outputChannel())), stageDef, workOrder.getInputs(), inputSliceReader, frameContext, exec, cancellationId, parallelism, this.processorBouncer, counters, MSQWarningReportPublisher2);
        if (stageDef.doesShuffle()) {
            ClusterBy clusterBy = workOrder.getStageDefinition().getShuffleSpec().get().getClusterBy();
            CountingOutputChannelFactory shuffleOutputChannelFactory = new CountingOutputChannelFactory(this.makeStageOutputChannelFactory(frameContext, stageDef.getStageNumber()), counters.channel(CounterNames.shuffleChannel()));
            if (stageDef.doesSortDuringShuffle()) {
                stagePartitionBoundariesFuture = stageDef.mustGatherResultKeyStatistics() ? SettableFuture.create() : Futures.immediateFuture((Object)kernel.getResultPartitionBoundaries());
                outputChannelsFuture = WorkerImpl.superSortOutputChannels(workOrder.getStageDefinition(), clusterBy, workerResultAndOutputChannels.getOutputChannels(), (ListenableFuture<ClusterByPartitions>)stagePartitionBoundariesFuture, shuffleOutputChannelFactory, exec, cancellationId, frameContext.memoryParameters(), this.context, this.kernelManipulationQueue, counters.sortProgress());
            } else {
                OutputChannel outputChannel = shuffleOutputChannelFactory.openChannel(0);
                FrameChannelMuxer muxer = new FrameChannelMuxer(workerResultAndOutputChannels.getOutputChannels().getAllChannels().stream().map(OutputChannel::getReadableChannel).collect(Collectors.toList()), outputChannel.getWritableChannel());
                outputChannelsFuture = Futures.transform((ListenableFuture)exec.runFully((FrameProcessor)muxer, cancellationId), ignored -> OutputChannels.wrap(Collections.singletonList(outputChannel.readOnly())));
                stagePartitionBoundariesFuture = null;
            }
        } else {
            stagePartitionBoundariesFuture = null;
            outputChannelsFuture = Futures.immediateFuture((Object)workerResultAndOutputChannels.getOutputChannels().readOnly());
        }
        Futures.addCallback((ListenableFuture)Futures.allAsList(Arrays.asList(workerResultAndOutputChannels.getResultFuture(), Futures.transform((ListenableFuture)outputChannelsFuture, (Function)new Function<OutputChannels, OutputChannels>(){

            public OutputChannels apply(OutputChannels channels) {
                WorkerImpl.sanityCheckOutputChannels(channels);
                return channels;
            }
        }))), (FutureCallback)new FutureCallback<List<Object>>(){

            public void onSuccess(List<Object> workerResultAndOutputChannelsResolved) {
                Object resultObject = workerResultAndOutputChannelsResolved.get(0);
                OutputChannels outputChannels = (OutputChannels)workerResultAndOutputChannelsResolved.get(1);
                for (OutputChannel channel : outputChannels.getAllChannels()) {
                    WorkerImpl.this.stageOutputs.computeIfAbsent(stageDef.getId(), ignored1 -> new ConcurrentHashMap()).computeIfAbsent(channel.getPartitionNumber(), ignored2 -> channel.getReadableChannel());
                }
                if (WorkerImpl.this.durableStageStorageEnabled) {
                    DurableStorageOutputChannelFactory durableStorageOutputChannelFactory = DurableStorageOutputChannelFactory.createStandardImplementation(WorkerImpl.this.task.getControllerTaskId(), WorkerImpl.this.task().getWorkerNumber(), stageDef.getStageNumber(), WorkerImpl.this.task().getId(), frameContext.memoryParameters().getStandardFrameSize(), MSQTasks.makeStorageConnector(WorkerImpl.this.context.injector()));
                    try {
                        durableStorageOutputChannelFactory.createSuccessFile(WorkerImpl.this.task.getId());
                    }
                    catch (IOException e) {
                        throw new ISE((Throwable)e, "Unable to create the success file [%s] at the location [%s]", new Object[]{"__success", DurableStorageUtils.getSuccessFilePath(WorkerImpl.this.task.getControllerTaskId(), stageDef.getStageNumber(), WorkerImpl.this.task().getWorkerNumber())});
                    }
                }
                WorkerImpl.this.kernelManipulationQueue.add(holder -> holder.getStageKernelMap().get(stageDef.getId()).setResultsComplete(resultObject));
            }

            public void onFailure(Throwable t) {
                WorkerImpl.this.kernelManipulationQueue.add(kernelHolder -> kernelHolder.getStageKernelMap().get(stageDef.getId()).fail(t));
            }
        });
        return stageDef.mustGatherResultKeyStatistics() ? stagePartitionBoundariesFuture : null;
    }

    private static <FactoryType extends FrameProcessorFactory<I, WorkerClass, T, R>, I, WorkerClass extends FrameProcessor<T>, T, R> ResultAndChannels<R> makeAndRunWorkers(int workerNumber, FactoryType processorFactory, I processorFactoryExtraInfo, OutputChannelFactory outputChannelFactory, StageDefinition stageDefinition, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, FrameContext frameContext, FrameProcessorExecutor exec, String cancellationId, int parallelism, Bouncer processorBouncer, CounterTracker counters, MSQWarningReportPublisher warningPublisher) throws IOException {
        ProcessorsAndChannels<WorkerClass, T> processors = processorFactory.makeProcessors(stageDefinition, workerNumber, inputSlices, inputSliceReader, processorFactoryExtraInfo, outputChannelFactory, frameContext, parallelism, counters, e -> warningPublisher.publishException(stageDefinition.getStageNumber(), (Throwable)e));
        Sequence<WorkerClass> processorSequence = processors.processors();
        int maxOutstandingProcessors = processors.getOutputChannels().getAllChannels().isEmpty() ? Math.max(1, parallelism) : Math.max(1, Math.min(parallelism, processors.getOutputChannels().getAllChannels().size()));
        ListenableFuture workResultFuture = exec.runAllFully(processorSequence, processorFactory.newAccumulatedResult(), processorFactory::accumulateResult, maxOutstandingProcessors, processorBouncer, cancellationId);
        return new ResultAndChannels(workResultFuture, processors.getOutputChannels());
    }

    private static InputSliceReader makeInputSliceReader(QueryDefinition queryDef, InputChannels inputChannels, File temporaryDirectory, DataSegmentProvider segmentProvider) {
        return new MapInputSliceReader((Map<Class<? extends InputSlice>, InputSliceReader>)ImmutableMap.builder().put(NilInputSlice.class, (Object)NilInputSliceReader.INSTANCE).put(StageInputSlice.class, (Object)new StageInputSliceReader(queryDef.getQueryId(), inputChannels)).put(ExternalInputSlice.class, (Object)new ExternalInputSliceReader(temporaryDirectory)).put(SegmentsInputSlice.class, (Object)new SegmentsInputSliceReader(segmentProvider)).build());
    }

    private static ListenableFuture<OutputChannels> superSortOutputChannels(StageDefinition stageDefinition, ClusterBy clusterBy, OutputChannels processorOutputChannels, ListenableFuture<ClusterByPartitions> stagePartitionBoundariesFuture, OutputChannelFactory outputChannelFactory, FrameProcessorExecutor exec, String cancellationId, WorkerMemoryParameters memoryParameters, WorkerContext context, BlockingQueue<Consumer<KernelHolder>> kernelManipulationQueue, SuperSorterProgressTracker superSorterProgressTracker) throws IOException {
        List<Object> channelsToSuperSort;
        if (!stageDefinition.doesShuffle()) {
            throw new ISE("Output channels do not need shuffling", new Object[0]);
        }
        if (processorOutputChannels.getAllChannels().isEmpty()) {
            if (stageDefinition.mustGatherResultKeyStatistics()) {
                kernelManipulationQueue.add(holder -> holder.getStageKernelMap().get(stageDefinition.getId()).setResultKeyStatisticsSnapshot(ClusterByStatisticsSnapshot.empty()));
            }
            BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
            channel.writable().close();
            channelsToSuperSort = Collections.singletonList(channel.readable());
        } else {
            channelsToSuperSort = stageDefinition.mustGatherResultKeyStatistics() ? WorkerImpl.collectKeyStatistics(stageDefinition, clusterBy, processorOutputChannels, exec, memoryParameters.getPartitionStatisticsMaxRetainedBytes(), cancellationId, kernelManipulationQueue) : processorOutputChannels.getAllChannels().stream().map(OutputChannel::getReadableChannel).collect(Collectors.toList());
        }
        File sorterTmpDir = new File(context.tempDir(), "super-sort-" + UUID.randomUUID());
        FileUtils.mkdirp((File)sorterTmpDir);
        if (!sorterTmpDir.isDirectory()) {
            throw new IOException("Cannot create directory: " + sorterTmpDir);
        }
        SuperSorter sorter = new SuperSorter(channelsToSuperSort, stageDefinition.getFrameReader(), clusterBy, stagePartitionBoundariesFuture, exec, sorterTmpDir, outputChannelFactory, () -> ArenaMemoryAllocator.createOnHeap((int)memoryParameters.getLargeFrameSize()), memoryParameters.getSuperSorterMaxActiveProcessors(), memoryParameters.getSuperSorterMaxChannelsPerProcessor(), -1L, cancellationId, superSorterProgressTracker);
        return sorter.run();
    }

    private static List<ReadableFrameChannel> collectKeyStatistics(final StageDefinition stageDefinition, ClusterBy clusterBy, OutputChannels processorOutputChannels, FrameProcessorExecutor exec, int partitionStatisticsMaxRetainedBytes, String cancellationId, final BlockingQueue<Consumer<KernelHolder>> kernelManipulationQueue) {
        ArrayList<ReadableFrameChannel> retVal = new ArrayList<ReadableFrameChannel>();
        ArrayList<KeyStatisticsCollectionProcessor> processors = new ArrayList<KeyStatisticsCollectionProcessor>();
        for (OutputChannel outputChannel : processorOutputChannels.getAllChannels()) {
            BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
            retVal.add(channel.readable());
            processors.add(new KeyStatisticsCollectionProcessor(outputChannel.getReadableChannel(), channel.writable(), stageDefinition.getFrameReader(), clusterBy, stageDefinition.createResultKeyStatisticsCollector(partitionStatisticsMaxRetainedBytes)));
        }
        ListenableFuture clusterByStatisticsCollectorFuture = exec.runAllFully(Sequences.simple(processors), (Object)stageDefinition.createResultKeyStatisticsCollector(partitionStatisticsMaxRetainedBytes), ClusterByStatisticsCollector::addAll, processors.size(), Bouncer.unlimited(), cancellationId);
        Futures.addCallback((ListenableFuture)clusterByStatisticsCollectorFuture, (FutureCallback)new FutureCallback<ClusterByStatisticsCollector>(){

            public void onSuccess(ClusterByStatisticsCollector result) {
                kernelManipulationQueue.add(holder -> holder.getStageKernelMap().get(stageDefinition.getId()).setResultKeyStatisticsSnapshot(result.snapshot()));
            }

            public void onFailure(Throwable t) {
                kernelManipulationQueue.add(holder -> {
                    log.noStackTrace().warn(t, "Failed to gather clusterBy statistics for stage [%s]", new Object[]{stageDefinition.getId()});
                    holder.getStageKernelMap().get(stageDefinition.getId()).fail(t);
                });
            }
        });
        return retVal;
    }

    private static void sanityCheckOutputChannels(OutputChannels outputChannels) {
        IntBidirectionalIterator intBidirectionalIterator = outputChannels.getPartitionNumbers().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int partitionNumber = (Integer)intBidirectionalIterator.next();
            List outputChannelsForPartition = outputChannels.getChannelsForPartition(partitionNumber);
            Preconditions.checkState((partitionNumber >= 0 ? 1 : 0) != 0, (String)"Expected partitionNumber >= 0, but got [%s]", (Object[])new Object[]{partitionNumber});
            Preconditions.checkState((outputChannelsForPartition.size() == 1 ? 1 : 0) != 0, (String)"Expected one channel for partition [%s], but got [%s]", (Object[])new Object[]{partitionNumber, outputChannelsForPartition.size()});
        }
    }

    private static void logKernelStatus(Collection<WorkerStageKernel> kernels) {
        if (log.isDebugEnabled()) {
            log.debug("Stages: %s", new Object[]{kernels.stream().sorted(Comparator.comparing(k -> k.getStageDefinition().getStageNumber())).map(WorkerImpl::makeKernelStageStatusString).collect(Collectors.joining("; "))});
        }
    }

    private static String makeKernelStageStatusString(WorkerStageKernel kernel) {
        String inputPartitionNumbers = StreamSupport.stream(InputSlices.allReadablePartitions(kernel.getWorkOrder().getInputs()).spliterator(), false).map(ReadablePartition::getPartitionNumber).sorted().map(String::valueOf).collect(Collectors.joining(","));
        String shuffleStatus = kernel.getStageDefinition().doesShuffle() ? ">" + (kernel.hasResultPartitionBoundaries() ? Integer.valueOf(kernel.getResultPartitionBoundaries().size()) : "?") : "";
        return StringUtils.format((String)"S%d:W%d:P[%s]%s:%s:%s", (Object[])new Object[]{kernel.getStageDefinition().getStageNumber(), kernel.getWorkOrder().getWorkerNumber(), inputPartitionNumbers, shuffleStatus, kernel.getStageDefinition().doesShuffle() ? "SHUFFLE" : "RETAIN", kernel.getPhase()});
    }

    private static class ResultAndChannels<T> {
        private final ListenableFuture<T> resultFuture;
        private final OutputChannels outputChannels;

        public ResultAndChannels(ListenableFuture<T> resultFuture, OutputChannels outputChannels) {
            this.resultFuture = resultFuture;
            this.outputChannels = outputChannels;
        }

        public ListenableFuture<T> getResultFuture() {
            return this.resultFuture;
        }

        public OutputChannels getOutputChannels() {
            return this.outputChannels;
        }
    }

    private class KernelHolder {
        private boolean done = false;

        private KernelHolder() {
        }

        public Map<StageId, WorkerStageKernel> getStageKernelMap() {
            return WorkerImpl.this.stageKernelMap;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone() {
            this.done = true;
        }
    }

    private class WorkerOrLocalInputChannelFactory
    implements InputChannelFactory {
        private final Supplier<List<String>> taskList;
        private final WorkerInputChannelFactory workerInputChannelFactory;

        public WorkerOrLocalInputChannelFactory(Supplier<List<String>> taskList) {
            this.workerInputChannelFactory = new WorkerInputChannelFactory(WorkerImpl.this.workerClient, taskList);
            this.taskList = taskList;
        }

        @Override
        public ReadableFrameChannel openChannel(StageId stageId, int workerNumber, int partitionNumber) {
            String taskId = this.taskList.get().get(workerNumber);
            if (taskId.equals(WorkerImpl.this.id())) {
                ConcurrentMap partitionOutputsForStage = (ConcurrentMap)WorkerImpl.this.stageOutputs.get(stageId);
                if (partitionOutputsForStage == null) {
                    throw new ISE("Unable to find outputs for stage: [%s]", new Object[]{stageId});
                }
                ReadableFrameChannel myChannel = (ReadableFrameChannel)partitionOutputsForStage.get(partitionNumber);
                if (myChannel instanceof ReadableFileFrameChannel) {
                    FrameFile frameFile = ((ReadableFileFrameChannel)myChannel).newFrameFileReference();
                    return new ReadableFileFrameChannel(frameFile);
                }
                if (myChannel instanceof ReadableNilFrameChannel) {
                    return myChannel;
                }
                throw new ISE("Output for stage: [%s] are stored in an instance of %s which is not supported", new Object[]{stageId, myChannel.getClass()});
            }
            return this.workerInputChannelFactory.openChannel(stageId, workerNumber, partitionNumber);
        }
    }
}

