/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.msq.querykit.LazyResourceHolder;
import org.apache.druid.msq.rpc.CoordinatorServiceClient;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;

public class TaskDataSegmentProvider
implements DataSegmentProvider {
    private final CoordinatorServiceClient coordinatorClient;
    private final SegmentCacheManager segmentCacheManager;
    private final IndexIO indexIO;

    public TaskDataSegmentProvider(CoordinatorServiceClient coordinatorClient, SegmentCacheManager segmentCacheManager, IndexIO indexIO) {
        this.coordinatorClient = coordinatorClient;
        this.segmentCacheManager = segmentCacheManager;
        this.indexIO = indexIO;
    }

    public LazyResourceHolder<Segment> fetchSegment(SegmentId segmentId, ChannelCounters channelCounters) {
        try {
            return new LazyResourceHolder<Segment>(() -> {
                DataSegment dataSegment;
                try {
                    dataSegment = (DataSegment)FutureUtils.get(this.coordinatorClient.fetchUsedSegment(segmentId.getDataSource(), segmentId.toString()), (boolean)true);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RE((Throwable)e, "Failed to fetch segment details from Coordinator for [%s]", new Object[]{segmentId});
                }
                Closer closer = Closer.create();
                try {
                    File segmentDir = this.segmentCacheManager.getSegmentFiles(dataSegment);
                    closer.register(() -> FileUtils.deleteDirectory((File)segmentDir));
                    QueryableIndex index = this.indexIO.loadIndex(segmentDir);
                    int numRows = index.getNumRows();
                    long size = dataSegment.getSize();
                    closer.register(() -> channelCounters.addFile(numRows, size));
                    closer.register((Closeable)index);
                    return Pair.of((Object)new QueryableIndexSegment(index, dataSegment.getId()), (Object)closer);
                }
                catch (IOException | SegmentLoadingException e) {
                    throw CloseableUtils.closeInCatch((Throwable)new RE(e, "Failed to download segment [%s]", new Object[]{segmentId}), (Closeable)closer);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

