/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.DurableStorageConfigurationFault;
import org.apache.druid.msq.indexing.error.InsertTimeNullFault;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;
import org.apache.druid.msq.indexing.error.WorkerRpcFailedFault;
import org.apache.druid.msq.statistics.KeyCollectorFactory;
import org.apache.druid.msq.statistics.KeyCollectorSnapshotDeserializerModule;
import org.apache.druid.msq.statistics.KeyCollectors;
import org.apache.druid.server.DruidNode;
import org.apache.druid.storage.StorageConnector;

public class MSQTasks {
    static final String GENERIC_QUERY_FAILED_MESSAGE = "Query failed";
    private static final String TASK_ID_PREFIX = "query-";

    public static String controllerTaskId(@Nullable String queryId) {
        return TASK_ID_PREFIX + (queryId == null ? UUID.randomUUID().toString() : queryId);
    }

    public static String workerTaskId(String controllerTaskId, int workerNumber) {
        return StringUtils.format((String)"%s-worker%d", (Object[])new Object[]{controllerTaskId, workerNumber});
    }

    public static long primaryTimestampFromObjectForInsert(Object timestamp) {
        if (timestamp instanceof Long) {
            return (Long)timestamp;
        }
        if (timestamp == null) {
            throw new MSQException(InsertTimeNullFault.INSTANCE);
        }
        UnknownFault fault = UnknownFault.forMessage(StringUtils.format((String)"Incorrect type for [%s]", (Object[])new Object[]{"__time"}));
        throw new MSQException(fault);
    }

    static ObjectMapper decorateObjectMapperForKeyCollectorSnapshot(ObjectMapper mapper, ClusterBy clusterBy, boolean aggregate) {
        KeyCollectorFactory<?, ?> keyCollectorFactory = KeyCollectors.makeStandardFactory(clusterBy, aggregate);
        ObjectMapper mapperCopy = mapper.copy();
        mapperCopy.registerModule((Module)new KeyCollectorSnapshotDeserializerModule(keyCollectorFactory));
        return mapperCopy;
    }

    @Nullable
    static String getHostFromSelfNode(@Nullable DruidNode selfNode) {
        return selfNode != null ? selfNode.getHostAndPortToUse() : null;
    }

    static StorageConnector makeStorageConnector(Injector injector) {
        try {
            return (StorageConnector)injector.getInstance(Key.get(StorageConnector.class, MultiStageQuery.class));
        }
        catch (Exception e) {
            throw new MSQException(new DurableStorageConfigurationFault(e.toString()));
        }
    }

    static MSQErrorReport makeErrorReport(String controllerTaskId, String controllerHost, @Nullable MSQErrorReport controllerErrorReport, @Nullable MSQErrorReport workerErrorReport) {
        if (controllerErrorReport == null && workerErrorReport == null) {
            return MSQErrorReport.fromFault(controllerTaskId, controllerHost, null, UnknownFault.forMessage(GENERIC_QUERY_FAILED_MESSAGE));
        }
        if (controllerErrorReport == null) {
            return workerErrorReport;
        }
        if (workerErrorReport != null && (controllerErrorReport.getFault() instanceof WorkerFailedFault || controllerErrorReport.getFault() instanceof WorkerRpcFailedFault || controllerErrorReport.getFault() instanceof CanceledFault)) {
            return workerErrorReport;
        }
        return controllerErrorReport;
    }

    static String errorReportToLogMessage(MSQErrorReport errorReport) {
        StringBuilder logMessage = new StringBuilder("Work failed");
        if (errorReport.getStageNumber() != null) {
            logMessage.append("; stage ").append(errorReport.getStageNumber());
        }
        logMessage.append("; task ").append(errorReport.getTaskId());
        if (errorReport.getHost() != null) {
            logMessage.append("; host ").append(errorReport.getHost());
        }
        logMessage.append(": ").append(errorReport.getFault().getCodeWithMessage());
        if (errorReport.getExceptionStackTrace() != null) {
            if (errorReport.getFault() instanceof UnknownFault) {
                logMessage.append('\n').append(errorReport.getExceptionStackTrace());
            } else {
                String stackTrace = errorReport.getExceptionStackTrace();
                int firstNewLine = stackTrace.indexOf(10);
                logMessage.append(" (").append(firstNewLine > 0 ? stackTrace.substring(0, firstNewLine) : stackTrace).append(")");
            }
        }
        return logMessage.toString();
    }
}

