/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.channel.FrameChannelSequence;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartition;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.MarkSegmentsAsUnusedAction;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.exec.ClusterStatisticsMergeMode;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.ExceptionWrappingWorkerClient;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.QueryValidator;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerSketchFetcher;
import org.apache.druid.msq.indexing.ColumnMapping;
import org.apache.druid.msq.indexing.ColumnMappings;
import org.apache.druid.msq.indexing.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.indexing.InputChannelsImpl;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.MSQWorkerTaskLauncher;
import org.apache.druid.msq.indexing.SegmentGeneratorFrameProcessorFactory;
import org.apache.druid.msq.indexing.TaskReportMSQDestination;
import org.apache.druid.msq.indexing.WorkerCount;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.FaultsExceededChecker;
import org.apache.druid.msq.indexing.error.InsertCannotAllocateSegmentFault;
import org.apache.druid.msq.indexing.error.InsertCannotBeEmptyFault;
import org.apache.druid.msq.indexing.error.InsertCannotOrderByDescendingFault;
import org.apache.druid.msq.indexing.error.InsertCannotReplaceExistingSegmentFault;
import org.apache.druid.msq.indexing.error.InsertLockPreemptedFault;
import org.apache.druid.msq.indexing.error.InsertTimeOutOfBoundsFault;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.MSQWarnings;
import org.apache.druid.msq.indexing.error.QueryNotSupportedFault;
import org.apache.druid.msq.indexing.error.TooManyPartitionsFault;
import org.apache.druid.msq.indexing.error.TooManyWarningsFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.indexing.report.MSQResultsReport;
import org.apache.druid.msq.indexing.report.MSQStagesReport;
import org.apache.druid.msq.indexing.report.MSQStatusReport;
import org.apache.druid.msq.indexing.report.MSQTaskReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.InputSpecSlicerFactory;
import org.apache.druid.msq.input.InputSpecs;
import org.apache.druid.msq.input.MapInputSpecSlicer;
import org.apache.druid.msq.input.external.ExternalInputSpec;
import org.apache.druid.msq.input.external.ExternalInputSpecSlicer;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.input.stage.StageInputSpecSlicer;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.input.table.TableInputSpecSlicer;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.StagePartition;
import org.apache.druid.msq.kernel.TargetSizeShuffleSpec;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernel;
import org.apache.druid.msq.kernel.controller.ControllerStagePhase;
import org.apache.druid.msq.kernel.controller.WorkerInputs;
import org.apache.druid.msq.querykit.DataSegmentTimelineView;
import org.apache.druid.msq.querykit.MultiQueryKit;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.groupby.GroupByQueryKit;
import org.apache.druid.msq.querykit.scan.ScanQueryKit;
import org.apache.druid.msq.shuffle.DurableStorageInputChannelFactory;
import org.apache.druid.msq.shuffle.DurableStorageUtils;
import org.apache.druid.msq.shuffle.WorkerInputChannelFactory;
import org.apache.druid.msq.statistics.CompleteKeyStatisticsInformation;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;
import org.apache.druid.msq.util.DimensionSchemaUtils;
import org.apache.druid.msq.util.IntervalUtils;
import org.apache.druid.msq.util.MSQFutureUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.msq.util.PassthroughAggregatorFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.DruidNode;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ControllerImpl
implements Controller {
    private static final Logger log = new Logger(ControllerImpl.class);
    private final MSQControllerTask task;
    private final ControllerContext context;
    private final BlockingQueue<Consumer<ControllerQueryKernel>> kernelManipulationQueue = new ArrayBlockingQueue<Consumer<ControllerQueryKernel>>(100000);
    private final AtomicReference<MSQErrorReport> workerErrorRef = new AtomicReference();
    private final ConcurrentLinkedQueue<MSQErrorReport> workerWarnings = new ConcurrentLinkedQueue();
    private final AtomicReference<QueryDefinition> queryDefRef = new AtomicReference();
    private final CounterSnapshotsTree taskCountersForLiveReports = new CounterSnapshotsTree();
    private final ConcurrentHashMap<Integer, ControllerStagePhase> stagePhasesForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Interval> stageRuntimesForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> stageWorkerCountsForLiveReports = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Integer> stagePartitionCountsForLiveReports = new ConcurrentHashMap();
    private WorkerSketchFetcher workerSketchFetcher;
    private volatile DateTime queryStartTime = null;
    private volatile DruidNode selfDruidNode;
    private volatile MSQWorkerTaskLauncher workerTaskLauncher;
    private volatile WorkerClient netClient;
    private volatile FaultsExceededChecker faultsExceededChecker = null;

    public ControllerImpl(MSQControllerTask task, ControllerContext context) {
        this.task = task;
        this.context = context;
    }

    @Override
    public String id() {
        return this.task.getId();
    }

    @Override
    public MSQControllerTask task() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus run() throws Exception {
        try (Closer closer = Closer.create();){
            TaskStatus taskStatus = this.runTask(closer);
            return taskStatus;
        }
    }

    @Override
    public void stopGracefully() {
        QueryDefinition queryDef = this.queryDefRef.get();
        log.info("Query [%s] canceled.", new Object[]{queryDef != null ? queryDef.getQueryId() : "<no id yet>"});
        this.addToKernelManipulationQueue(kernel -> {
            throw new MSQException(CanceledFault.INSTANCE);
        });
    }

    public TaskStatus runTask(Closer closer) {
        MSQErrorReport errorForReport;
        TaskState taskStateForReport;
        QueryDefinition queryDef = null;
        ControllerQueryKernel queryKernel = null;
        ListenableFuture workerTaskRunnerFuture = null;
        CounterSnapshotsTree countersSnapshot = null;
        Yielder<Object[]> resultsYielder = null;
        Throwable exceptionEncountered = null;
        try {
            this.queryStartTime = DateTimes.nowUtc();
            queryDef = this.initializeQueryDefAndState(closer);
            InputSpecSlicerFactory inputSpecSlicerFactory = ControllerImpl.makeInputSpecSlicerFactory(this.makeDataSegmentTimelineView());
            Pair queryRunResult = new RunQueryUntilDone(queryDef, inputSpecSlicerFactory, closer).run();
            queryKernel = (ControllerQueryKernel)Preconditions.checkNotNull((Object)queryRunResult.lhs);
            workerTaskRunnerFuture = (ListenableFuture)Preconditions.checkNotNull((Object)queryRunResult.rhs);
            resultsYielder = this.getFinalResultsYielder(queryDef, queryKernel);
            this.publishSegmentsIfNeeded(queryDef, queryKernel);
        }
        catch (Throwable e) {
            exceptionEncountered = e;
        }
        try {
            countersSnapshot = this.getFinalCountersSnapshot(queryKernel);
        }
        catch (Throwable e) {
            if (exceptionEncountered != null) {
                exceptionEncountered.addSuppressed(e);
            }
            exceptionEncountered = e;
        }
        if (queryKernel != null && queryKernel.isSuccess() && exceptionEncountered == null) {
            taskStateForReport = TaskState.SUCCESS;
            errorForReport = null;
        } else {
            String selfHost = MSQTasks.getHostFromSelfNode(this.selfDruidNode);
            MSQErrorReport controllerError = exceptionEncountered != null ? MSQErrorReport.fromException(this.id(), selfHost, null, exceptionEncountered) : null;
            MSQErrorReport workerError = this.workerErrorRef.get();
            taskStateForReport = TaskState.FAILED;
            errorForReport = MSQTasks.makeErrorReport(this.id(), selfHost, controllerError, workerError);
            if (controllerError != null) {
                log.warn("Controller: %s", new Object[]{MSQTasks.errorReportToLogMessage(controllerError)});
            }
            if (workerError != null) {
                log.warn("Worker: %s", new Object[]{MSQTasks.errorReportToLogMessage(workerError)});
            }
        }
        try {
            MSQStagesReport stagesReport;
            if (queryDef != null) {
                Map<Integer, ControllerStagePhase> stagePhaseMap;
                if (queryKernel != null) {
                    queryKernel.markSuccessfulTerminalStagesAsFinished();
                    stagePhaseMap = queryKernel.getActiveStages().stream().collect(Collectors.toMap(StageId::getStageNumber, queryKernel::getStagePhase));
                } else {
                    stagePhaseMap = Collections.emptyMap();
                }
                stagesReport = ControllerImpl.makeStageReport(queryDef, stagePhaseMap, this.stageRuntimesForLiveReports, this.stageWorkerCountsForLiveReports, this.stagePartitionCountsForLiveReports);
            } else {
                stagesReport = null;
            }
            MSQResultsReport resultsReport = resultsYielder != null ? ControllerImpl.makeResultsTaskReport(queryDef, resultsYielder, this.task.getQuerySpec().getColumnMappings(), this.task.getSqlTypeNames()) : null;
            MSQTaskReportPayload taskReportPayload = new MSQTaskReportPayload(ControllerImpl.makeStatusReport(taskStateForReport, errorForReport, this.workerWarnings, this.queryStartTime, new Interval((ReadableInstant)this.queryStartTime, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis(), this.workerTaskLauncher), stagesReport, countersSnapshot, resultsReport);
            this.context.writeReports(this.id(), TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{new MSQTaskReport(this.id(), taskReportPayload)}));
        }
        catch (Throwable e) {
            log.warn(e, "Error encountered while writing task report. Skipping.", new Object[0]);
        }
        if (queryKernel != null && queryKernel.isSuccess()) {
            this.postFinishToAllTasks();
            this.workerTaskLauncher.stop(false);
        } else if (this.workerTaskLauncher != null) {
            this.workerTaskLauncher.stop(true);
        }
        if (workerTaskRunnerFuture != null) {
            try {
                workerTaskRunnerFuture.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cleanUpDurableStorageIfNeeded();
        if (taskStateForReport == TaskState.SUCCESS) {
            return TaskStatus.success((String)this.id());
        }
        return TaskStatus.failure((String)this.id(), (String)errorForReport.getFault().getCodeWithMessage());
    }

    private void addToKernelManipulationQueue(Consumer<ControllerQueryKernel> kernelConsumer) {
        if (!this.kernelManipulationQueue.offer(kernelConsumer)) {
            String message = "Controller kernel queue is full. Main controller loop may be delayed or stuck.";
            log.warn("Controller kernel queue is full. Main controller loop may be delayed or stuck.", new Object[0]);
            throw new IllegalStateException("Controller kernel queue is full. Main controller loop may be delayed or stuck.");
        }
    }

    private QueryDefinition initializeQueryDefAndState(Closer closer) {
        this.selfDruidNode = this.context.selfNode();
        this.context.registerController(this, closer);
        this.netClient = new ExceptionWrappingWorkerClient(this.context.taskClientFor(this));
        closer.register(this.netClient::close);
        ClusterStatisticsMergeMode clusterStatisticsMergeMode = MultiStageQueryContext.getClusterStatisticsMergeMode(this.task.getQuerySpec().getQuery().context());
        log.debug("Query [%s] cluster statistics merge mode is set to %s.", new Object[]{this.id(), clusterStatisticsMergeMode});
        int statisticsMaxRetainedBytes = WorkerMemoryParameters.createProductionInstanceForController(this.context.injector()).getPartitionStatisticsMaxRetainedBytes();
        this.workerSketchFetcher = new WorkerSketchFetcher(this.netClient, clusterStatisticsMergeMode, statisticsMaxRetainedBytes);
        closer.register(this.workerSketchFetcher::close);
        boolean isDurableStorageEnabled = MultiStageQueryContext.isDurableStorageEnabled(this.task.getQuerySpec().getQuery().context());
        QueryDefinition queryDef = ControllerImpl.makeQueryDefinition(this.id(), this.makeQueryControllerToolKit(), this.task.getQuerySpec(), this.context.jsonMapper());
        QueryValidator.validateQueryDef(queryDef);
        this.queryDefRef.set(queryDef);
        log.debug("Query [%s] durable storage mode is set to %s.", new Object[]{queryDef.getQueryId(), isDurableStorageEnabled});
        long maxParseExceptions = -1L;
        if (this.task.getSqlQueryContext() != null) {
            maxParseExceptions = Optional.ofNullable(this.task.getSqlQueryContext().get("maxParseExceptions")).map(DimensionHandlerUtils::convertObjectToLong).orElse(MSQWarnings.DEFAULT_MAX_PARSE_EXCEPTIONS_ALLOWED);
        }
        this.workerTaskLauncher = new MSQWorkerTaskLauncher(this.id(), this.task.getDataSource(), this.context, isDurableStorageEnabled, maxParseExceptions, TimeUnit.SECONDS.toMillis(600L + (long)ThreadLocalRandom.current().nextInt(-4, 5) * 30L));
        this.faultsExceededChecker = new FaultsExceededChecker((Map<String, Long>)ImmutableMap.of((Object)"CannotParseExternalData", (Object)maxParseExceptions));
        return queryDef;
    }

    @Override
    public void updatePartialKeyStatisticsInformation(int stageNumber, int workerNumber, Object partialKeyStatisticsInformationObject) {
        this.addToKernelManipulationQueue(queryKernel -> {
            PartialKeyStatisticsInformation partialKeyStatisticsInformation;
            StageId stageId = queryKernel.getStageId(stageNumber);
            StageDefinition stageDef = queryKernel.getStageDefinition(stageId);
            ObjectMapper mapper = MSQTasks.decorateObjectMapperForKeyCollectorSnapshot(this.context.jsonMapper(), stageDef.getShuffleSpec().get().getClusterBy(), stageDef.getShuffleSpec().get().doesAggregateByClusterKey());
            try {
                partialKeyStatisticsInformation = (PartialKeyStatisticsInformation)mapper.convertValue(partialKeyStatisticsInformationObject, PartialKeyStatisticsInformation.class);
            }
            catch (IllegalArgumentException e) {
                throw new IAE((Throwable)e, "Unable to deserialize the key statistic for stage [%s] received from the worker [%d]", new Object[]{stageId, workerNumber});
            }
            queryKernel.addPartialKeyStatisticsForStageAndWorker(stageId, workerNumber, partialKeyStatisticsInformation);
            if (queryKernel.getStagePhase(stageId).equals((Object)ControllerStagePhase.MERGING_STATISTICS)) {
                List<String> workerTaskIds = this.workerTaskLauncher.getTaskList();
                CompleteKeyStatisticsInformation completeKeyStatisticsInformation = queryKernel.getCompleteKeyStatisticsInformation(stageId);
                CompletableFuture<Either<Long, ClusterByPartitions>> clusterByPartitionsCompletableFuture = this.workerSketchFetcher.submitFetcherTask(completeKeyStatisticsInformation, workerTaskIds, stageDef, queryKernel.getWorkerInputsForStage(stageId).workers());
                clusterByPartitionsCompletableFuture.whenComplete((clusterByPartitionsEither, throwable) -> this.addToKernelManipulationQueue(holder -> {
                    if (throwable != null) {
                        log.error("Error while fetching stats for stageId[%s]", new Object[]{stageId});
                        if (throwable instanceof MSQException) {
                            holder.failStageForReason(stageId, ((MSQException)throwable).getFault());
                        } else {
                            holder.failStageForReason(stageId, UnknownFault.forException(throwable));
                        }
                    } else if (clusterByPartitionsEither.isError()) {
                        holder.failStageForReason(stageId, new TooManyPartitionsFault(stageDef.getMaxPartitionCount()));
                    } else {
                        log.debug("Query [%s] Partition boundaries generated for stage %s", new Object[]{this.id(), stageId});
                        holder.setClusterByPartitionBoundaries(stageId, (ClusterByPartitions)clusterByPartitionsEither.valueOrThrow());
                    }
                    holder.transitionStageKernel(stageId, queryKernel.getStagePhase(stageId));
                }));
            }
        });
    }

    @Override
    public void workerError(MSQErrorReport errorReport) {
        if (!this.workerTaskLauncher.isTaskCanceledByController(errorReport.getTaskId())) {
            this.workerErrorRef.compareAndSet(null, errorReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workerWarning(List<MSQErrorReport> errorReports) {
        long numReportsToAddCheck = Math.min((long)errorReports.size(), 10000L - (long)this.workerWarnings.size());
        if (numReportsToAddCheck > 0L) {
            ConcurrentLinkedQueue<MSQErrorReport> concurrentLinkedQueue = this.workerWarnings;
            synchronized (concurrentLinkedQueue) {
                long numReportsToAdd = Math.min((long)errorReports.size(), 10000L - (long)this.workerWarnings.size());
                int i = 0;
                while ((long)i < numReportsToAdd) {
                    this.workerWarnings.add(errorReports.get(i));
                    ++i;
                }
            }
        }
    }

    @Override
    public void updateCounters(CounterSnapshotsTree snapshotsTree) {
        this.taskCountersForLiveReports.putAll(snapshotsTree);
        Optional<Pair<String, Long>> warningsExceeded = this.faultsExceededChecker.addFaultsAndCheckIfExceeded(this.taskCountersForLiveReports);
        if (warningsExceeded.isPresent()) {
            String errorCode = (String)warningsExceeded.get().lhs;
            Long limit = (Long)warningsExceeded.get().rhs;
            this.workerError(MSQErrorReport.fromFault(this.id(), this.selfDruidNode.getHost(), null, new TooManyWarningsFault(limit.intValue(), errorCode)));
            this.addToKernelManipulationQueue(queryKernel -> queryKernel.getActiveStages().forEach(queryKernel::failStage));
        }
    }

    @Override
    public void resultsComplete(String queryId, int stageNumber, int workerNumber, Object resultObject) {
        this.addToKernelManipulationQueue(queryKernel -> {
            Object convertedResultObject;
            StageId stageId = new StageId(queryId, stageNumber);
            try {
                convertedResultObject = this.context.jsonMapper().convertValue(resultObject, queryKernel.getStageDefinition(stageId).getProcessorFactory().getAccumulatedResultTypeReference());
            }
            catch (IllegalArgumentException e) {
                throw new IAE((Throwable)e, "Unable to deserialize the result object for stage [%s] received from the worker [%d]", new Object[]{stageId, workerNumber});
            }
            queryKernel.setResultsCompleteForStageAndWorker(stageId, workerNumber, convertedResultObject);
        });
    }

    @Override
    @Nullable
    public Map<String, TaskReport> liveReports() {
        QueryDefinition queryDef = this.queryDefRef.get();
        if (queryDef == null) {
            return null;
        }
        return TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{new MSQTaskReport(this.id(), new MSQTaskReportPayload(ControllerImpl.makeStatusReport(TaskState.RUNNING, null, this.workerWarnings, this.queryStartTime, this.queryStartTime == null ? -1L : new Interval((ReadableInstant)this.queryStartTime, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis(), this.workerTaskLauncher), ControllerImpl.makeStageReport(queryDef, this.stagePhasesForLiveReports, this.stageRuntimesForLiveReports, this.stageWorkerCountsForLiveReports, this.stagePartitionCountsForLiveReports), this.makeCountersSnapshotForLiveReports(), null))});
    }

    private List<SegmentIdWithShardSpec> generateSegmentIdsWithShardSpecs(DataSourceMSQDestination destination, RowSignature signature, ClusterBy clusterBy, ClusterByPartitions partitionBoundaries, boolean mayHaveMultiValuedClusterByFields) throws IOException {
        if (destination.isReplaceTimeChunks()) {
            return this.generateSegmentIdsWithShardSpecsForReplace(destination, signature, clusterBy, partitionBoundaries, mayHaveMultiValuedClusterByFields);
        }
        RowKeyReader keyReader = clusterBy.keyReader((ColumnInspector)signature);
        return this.generateSegmentIdsWithShardSpecsForAppend(destination, partitionBoundaries, keyReader);
    }

    private List<SegmentIdWithShardSpec> generateSegmentIdsWithShardSpecsForAppend(DataSourceMSQDestination destination, ClusterByPartitions partitionBoundaries, RowKeyReader keyReader) throws IOException {
        Granularity segmentGranularity = destination.getSegmentGranularity();
        String previousSegmentId = null;
        ArrayList<SegmentIdWithShardSpec> retVal = new ArrayList<SegmentIdWithShardSpec>(partitionBoundaries.size());
        for (ClusterByPartition partitionBoundary : partitionBoundaries) {
            SegmentIdWithShardSpec allocation;
            DateTime timestamp = ControllerImpl.getBucketDateTime(partitionBoundary, segmentGranularity, keyReader);
            try {
                allocation = (SegmentIdWithShardSpec)this.context.taskActionClient().submit((TaskAction)new SegmentAllocateAction(this.task.getDataSource(), timestamp, segmentGranularity, segmentGranularity, this.id(), previousSegmentId, false, (PartialShardSpec)NumberedPartialShardSpec.instance(), LockGranularity.TIME_CHUNK, TaskLockType.SHARED));
            }
            catch (ISE e) {
                if (ControllerImpl.isTaskLockPreemptedException((Exception)((Object)e))) {
                    throw new MSQException(e, InsertLockPreemptedFault.instance());
                }
                throw e;
            }
            if (allocation == null) {
                throw new MSQException(new InsertCannotAllocateSegmentFault(this.task.getDataSource(), segmentGranularity.bucket(timestamp)));
            }
            retVal.add(allocation);
            previousSegmentId = allocation.asSegmentId().toString();
        }
        return retVal;
    }

    private List<SegmentIdWithShardSpec> generateSegmentIdsWithShardSpecsForReplace(DataSourceMSQDestination destination, RowSignature signature, ClusterBy clusterBy, ClusterByPartitions partitionBoundaries, boolean mayHaveMultiValuedClusterByFields) throws IOException {
        RowKeyReader keyReader = clusterBy.keyReader((ColumnInspector)signature);
        SegmentIdWithShardSpec[] retVal = new SegmentIdWithShardSpec[partitionBoundaries.size()];
        Granularity segmentGranularity = destination.getSegmentGranularity();
        List<Object> shardColumns = mayHaveMultiValuedClusterByFields ? Collections.emptyList() : ControllerImpl.computeShardColumns(signature, clusterBy, this.task.getQuerySpec().getColumnMappings());
        HashMap<DateTime, List> partitionsByBucket = new HashMap<DateTime, List>();
        for (int i = 0; i < partitionBoundaries.ranges().size(); ++i) {
            ClusterByPartition partitionBoundary = (ClusterByPartition)partitionBoundaries.ranges().get(i);
            DateTime bucketDateTime = ControllerImpl.getBucketDateTime(partitionBoundary, segmentGranularity, keyReader);
            partitionsByBucket.computeIfAbsent(bucketDateTime, ignored -> new ArrayList()).add(Pair.of((Object)i, (Object)partitionBoundary));
        }
        for (Map.Entry bucketEntry : partitionsByBucket.entrySet()) {
            Interval interval = segmentGranularity.bucket((DateTime)bucketEntry.getKey());
            if (destination.getReplaceTimeChunks().stream().noneMatch(chunk -> chunk.contains((ReadableInterval)interval))) {
                throw new MSQException(new InsertTimeOutOfBoundsFault(interval));
            }
            List ranges = (List)bucketEntry.getValue();
            String version = null;
            List locks = (List)this.context.taskActionClient().submit((TaskAction)new LockListAction());
            for (TaskLock lock : locks) {
                if (!lock.getInterval().contains((ReadableInterval)interval)) continue;
                version = lock.getVersion();
            }
            if (version == null) {
                throw new MSQException(InsertLockPreemptedFault.INSTANCE);
            }
            for (int segmentNumber = 0; segmentNumber < ranges.size(); ++segmentNumber) {
                NumberedShardSpec shardSpec;
                int partitionNumber = (Integer)((Pair)ranges.get((int)segmentNumber)).lhs;
                if (shardColumns.isEmpty()) {
                    shardSpec = new NumberedShardSpec(segmentNumber, ranges.size());
                } else {
                    ClusterByPartition range = (ClusterByPartition)((Pair)ranges.get((int)segmentNumber)).rhs;
                    StringTuple start = segmentNumber == 0 ? null : ControllerImpl.makeStringTuple(clusterBy, keyReader, range.getStart());
                    StringTuple end = segmentNumber == ranges.size() - 1 ? null : ControllerImpl.makeStringTuple(clusterBy, keyReader, range.getEnd());
                    shardSpec = new DimensionRangeShardSpec(shardColumns, start, end, segmentNumber, Integer.valueOf(ranges.size()));
                }
                retVal[partitionNumber] = new SegmentIdWithShardSpec(this.task.getDataSource(), interval, version, (ShardSpec)shardSpec);
            }
        }
        return Arrays.asList(retVal);
    }

    @Override
    public List<String> getTaskIds() {
        if (this.workerTaskLauncher == null) {
            return Collections.emptyList();
        }
        return this.workerTaskLauncher.getTaskList();
    }

    @Nullable
    private Int2ObjectMap<Object> makeWorkerFactoryInfosForStage(QueryDefinition queryDef, int stageNumber, WorkerInputs workerInputs, @Nullable List<SegmentIdWithShardSpec> segmentsToGenerate) {
        if (MSQControllerTask.isIngestion(this.task.getQuerySpec()) && stageNumber == queryDef.getFinalStageDefinition().getStageNumber()) {
            return this.makeSegmentGeneratorWorkerFactoryInfos(workerInputs, segmentsToGenerate);
        }
        return null;
    }

    private QueryKit makeQueryControllerToolKit() {
        ImmutableMap kitMap = ImmutableMap.builder().put(ScanQuery.class, (Object)new ScanQueryKit(this.context.jsonMapper())).put(GroupByQuery.class, (Object)new GroupByQueryKit(this.context.jsonMapper())).build();
        return new MultiQueryKit((Map<Class<? extends Query>, QueryKit>)kitMap);
    }

    private DataSegmentTimelineView makeDataSegmentTimelineView() {
        return (dataSource, intervals) -> {
            Collection dataSegments = this.context.coordinatorClient().fetchUsedSegmentsInDataSourceForIntervals(dataSource, intervals);
            if (dataSegments.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(SegmentTimeline.forSegments((Iterable)dataSegments));
        };
    }

    private Int2ObjectMap<List<SegmentIdWithShardSpec>> makeSegmentGeneratorWorkerFactoryInfos(WorkerInputs workerInputs, List<SegmentIdWithShardSpec> segmentsToGenerate) {
        Int2ObjectAVLTreeMap retVal = new Int2ObjectAVLTreeMap();
        IntIterator intIterator = workerInputs.workers().iterator();
        while (intIterator.hasNext()) {
            int workerNumber = (Integer)intIterator.next();
            StageInputSlice stageInputSlice = (StageInputSlice)Iterables.getOnlyElement(workerInputs.inputsForWorker(workerNumber));
            ArrayList<SegmentIdWithShardSpec> workerSegments = new ArrayList<SegmentIdWithShardSpec>();
            retVal.put(workerNumber, workerSegments);
            for (ReadablePartition partition : stageInputSlice.getPartitions()) {
                workerSegments.add(segmentsToGenerate.get(partition.getPartitionNumber()));
            }
        }
        return retVal;
    }

    private void contactWorkersForStage(TaskContactFn contactFn, IntSet workers) {
        List<String> taskIds = this.getTaskIds();
        ArrayList<ListenableFuture<Void>> taskFutures = new ArrayList<ListenableFuture<Void>>(workers.size());
        IntIterator intIterator = workers.iterator();
        while (intIterator.hasNext()) {
            int workerNumber = (Integer)intIterator.next();
            String taskId = taskIds.get(workerNumber);
            taskFutures.add(contactFn.contactTask(this.netClient, taskId, workerNumber));
        }
        FutureUtils.getUnchecked(MSQFutureUtils.allAsList(taskFutures, true), (boolean)true);
    }

    private void startWorkForStage(QueryDefinition queryDef, ControllerQueryKernel queryKernel, int stageNumber, @Nullable List<SegmentIdWithShardSpec> segmentsToGenerate) {
        Int2ObjectMap<Object> extraInfos = this.makeWorkerFactoryInfosForStage(queryDef, stageNumber, queryKernel.getWorkerInputsForStage(queryKernel.getStageId(stageNumber)), segmentsToGenerate);
        Int2ObjectMap<WorkOrder> workOrders = queryKernel.createWorkOrders(stageNumber, extraInfos);
        this.contactWorkersForStage((netClient, taskId, workerNumber) -> netClient.postWorkOrder(taskId, (WorkOrder)workOrders.get(workerNumber)), workOrders.keySet());
    }

    private void postResultPartitionBoundariesForStage(QueryDefinition queryDef, int stageNumber, ClusterByPartitions resultPartitionBoundaries, IntSet workers) {
        this.contactWorkersForStage((netClient, taskId, workerNumber) -> netClient.postResultPartitionBoundaries(taskId, new StageId(queryDef.getQueryId(), stageNumber), resultPartitionBoundaries), workers);
    }

    private void publishAllSegments(Set<DataSegment> segments) throws IOException {
        DataSourceMSQDestination destination = (DataSourceMSQDestination)this.task.getQuerySpec().getDestination();
        if (destination.isReplaceTimeChunks()) {
            ImmutableSet segmentsToDrop;
            List<Interval> intervalsToDrop = this.findIntervalsToDrop((Set)Preconditions.checkNotNull(segments, (Object)"segments"));
            if (intervalsToDrop.isEmpty()) {
                segmentsToDrop = null;
            } else {
                segmentsToDrop = ImmutableSet.copyOf((Collection)((Collection)this.context.taskActionClient().submit((TaskAction)new RetrieveUsedSegmentsAction(this.task.getDataSource(), null, intervalsToDrop, Segments.ONLY_VISIBLE))));
                for (DataSegment segmentToDrop : segmentsToDrop) {
                    if (!destination.getReplaceTimeChunks().stream().noneMatch(interval -> interval.contains((ReadableInterval)segmentToDrop.getInterval()))) continue;
                    throw new MSQException(new InsertCannotReplaceExistingSegmentFault(segmentToDrop.getId()));
                }
            }
            if (segments.isEmpty()) {
                for (Interval interval2 : intervalsToDrop) {
                    this.context.taskActionClient().submit((TaskAction)new MarkSegmentsAsUnusedAction(this.task.getDataSource(), interval2));
                }
            } else {
                ControllerImpl.performSegmentPublish(this.context.taskActionClient(), SegmentTransactionalInsertAction.overwriteAction(null, segmentsToDrop, segments));
            }
        } else if (!segments.isEmpty()) {
            ControllerImpl.performSegmentPublish(this.context.taskActionClient(), SegmentTransactionalInsertAction.appendAction(segments, null, null));
        }
    }

    private List<Interval> findIntervalsToDrop(Set<DataSegment> publishedSegments) {
        DataSourceMSQDestination destination = (DataSourceMSQDestination)this.task.getQuerySpec().getDestination();
        ArrayList<Interval> replaceIntervals = new ArrayList<Interval>(JodaUtils.condenseIntervals(destination.getReplaceTimeChunks()));
        List publishIntervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform(publishedSegments, DataSegment::getInterval));
        return IntervalUtils.difference(replaceIntervals, publishIntervals);
    }

    private CounterSnapshotsTree getCountersFromAllTasks() {
        CounterSnapshotsTree retVal = new CounterSnapshotsTree();
        List<String> taskList = this.workerTaskLauncher.getTaskList();
        ArrayList<ListenableFuture<CounterSnapshotsTree>> futures = new ArrayList<ListenableFuture<CounterSnapshotsTree>>();
        for (String taskId : taskList) {
            futures.add(this.netClient.getCounters(taskId));
        }
        List snapshotsTrees = (List)FutureUtils.getUnchecked(MSQFutureUtils.allAsList(futures, true), (boolean)true);
        for (CounterSnapshotsTree snapshotsTree : snapshotsTrees) {
            retVal.putAll(snapshotsTree);
        }
        return retVal;
    }

    private void postFinishToAllTasks() {
        List<String> taskList = this.workerTaskLauncher.getTaskList();
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        for (String taskId : taskList) {
            futures.add(this.netClient.postFinish(taskId));
        }
        FutureUtils.getUnchecked(MSQFutureUtils.allAsList(futures, true), (boolean)true);
    }

    private CounterSnapshotsTree makeCountersSnapshotForLiveReports() {
        return CounterSnapshotsTree.fromMap(this.taskCountersForLiveReports.copyMap());
    }

    private CounterSnapshotsTree getFinalCountersSnapshot(@Nullable ControllerQueryKernel queryKernel) {
        if (queryKernel != null && queryKernel.isSuccess()) {
            return this.getCountersFromAllTasks();
        }
        return this.makeCountersSnapshotForLiveReports();
    }

    @Nullable
    private Yielder<Object[]> getFinalResultsYielder(QueryDefinition queryDef, ControllerQueryKernel queryKernel) {
        if (queryKernel.isSuccess() && ControllerImpl.isInlineResults(this.task.getQuerySpec())) {
            StageId finalStageId = queryKernel.getStageId(queryDef.getFinalStageDefinition().getStageNumber());
            List<String> taskIds = this.getTaskIds();
            Closer closer = Closer.create();
            ListeningExecutorService resultReaderExec = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"result-reader-%d"));
            closer.register(() -> resultReaderExec.shutdownNow());
            InputChannelFactory inputChannelFactory = MultiStageQueryContext.isDurableStorageEnabled(this.task.getQuerySpec().getQuery().context()) ? DurableStorageInputChannelFactory.createStandardImplementation(this.id(), MSQTasks.makeStorageConnector(this.context.injector()), closer) : new WorkerInputChannelFactory(this.netClient, () -> taskIds);
            InputChannelsImpl inputChannels = new InputChannelsImpl(queryDef, queryKernel.getResultPartitionsForStage(finalStageId), inputChannelFactory, () -> ArenaMemoryAllocator.createOnHeap((int)5000000), new FrameProcessorExecutor(resultReaderExec), null);
            return Yielders.each((Sequence)Sequences.concat((Iterable)StreamSupport.stream(queryKernel.getResultPartitionsForStage(finalStageId).spliterator(), false).map(readablePartition -> {
                try {
                    return new FrameChannelSequence(inputChannels.openChannel(new StagePartition(queryKernel.getStageDefinition(finalStageId).getId(), readablePartition.getPartitionNumber())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList())).flatMap(frame -> {
                Cursor cursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)queryKernel.getStageDefinition(finalStageId).getFrameReader());
                ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                ColumnMappings columnMappings = this.task.getQuerySpec().getColumnMappings();
                List selectors = columnMappings.getMappings().stream().map(mapping -> columnSelectorFactory.makeColumnValueSelector(mapping.getQueryColumn())).collect(Collectors.toList());
                ArrayList<Object[]> retVal = new ArrayList<Object[]>();
                while (!cursor.isDone()) {
                    Object[] row = new Object[columnMappings.getMappings().size()];
                    for (int i = 0; i < row.length; ++i) {
                        row[i] = ((ColumnValueSelector)selectors.get(i)).getObject();
                    }
                    retVal.add(row);
                    cursor.advance();
                }
                return Sequences.simple(retVal);
            }).withBaggage(() -> resultReaderExec.shutdownNow()));
        }
        return null;
    }

    private void publishSegmentsIfNeeded(QueryDefinition queryDef, ControllerQueryKernel queryKernel) throws IOException {
        if (queryKernel.isSuccess() && MSQControllerTask.isIngestion(this.task.getQuerySpec())) {
            StageId finalStageId = queryKernel.getStageId(queryDef.getFinalStageDefinition().getStageNumber());
            Set segments = (Set)queryKernel.getResultObjectForStage(finalStageId);
            log.info("Query [%s] publishing %d segments.", new Object[]{queryDef.getQueryId(), segments.size()});
            this.publishAllSegments(segments);
        }
    }

    private void cleanUpDurableStorageIfNeeded() {
        if (MultiStageQueryContext.isDurableStorageEnabled(this.task.getQuerySpec().getQuery().context())) {
            String controllerDirName = DurableStorageUtils.getControllerDirectory(this.task.getId());
            try {
                MSQTasks.makeStorageConnector(this.context.injector()).deleteRecursively(controllerDirName);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Error while cleaning up temporary files at path %s", new Object[]{controllerDirName});
            }
        }
    }

    private static QueryDefinition makeQueryDefinition(String queryId, QueryKit toolKit, MSQSpec querySpec, ObjectMapper jsonMapper) {
        QueryDefinition queryDef;
        ShuffleSpecFactory shuffleSpecFactory;
        MSQTuningConfig tuningConfig = querySpec.getTuningConfig();
        if (MSQControllerTask.isIngestion(querySpec)) {
            shuffleSpecFactory = (clusterBy, aggregate) -> new TargetSizeShuffleSpec(clusterBy, tuningConfig.getRowsPerSegment(), aggregate);
        } else if (querySpec.getDestination() instanceof TaskReportMSQDestination) {
            shuffleSpecFactory = ShuffleSpecFactories.singlePartition();
        } else {
            throw new ISE("Unsupported destination [%s]", new Object[]{querySpec.getDestination()});
        }
        Query queryToPlan = querySpec.getColumnMappings().hasOutputColumn("__time") ? querySpec.getQuery().withOverriddenContext((Map)ImmutableMap.of((Object)"__timeColumn", (Object)querySpec.getColumnMappings().getQueryColumnForOutputColumn("__time"))) : querySpec.getQuery();
        try {
            queryDef = toolKit.makeQueryDefinition(queryId, queryToPlan, toolKit, shuffleSpecFactory, tuningConfig.getMaxNumWorkers(), 0);
        }
        catch (MSQException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MSQException(e, QueryNotSupportedFault.INSTANCE);
        }
        if (MSQControllerTask.isIngestion(querySpec)) {
            RowSignature querySignature = queryDef.getFinalStageDefinition().getSignature();
            ClusterBy queryClusterBy = queryDef.getFinalStageDefinition().getClusterBy();
            ColumnMappings columnMappings = querySpec.getColumnMappings();
            StageDefinition finalShuffleStageDef = queryDef.getFinalStageDefinition();
            while (!finalShuffleStageDef.doesShuffle() && InputSpecs.getStageNumbers(finalShuffleStageDef.getInputSpecs()).size() == 1) {
                finalShuffleStageDef = queryDef.getStageDefinition((Integer)Iterables.getOnlyElement((Iterable)InputSpecs.getStageNumbers(finalShuffleStageDef.getInputSpecs())));
            }
            if (!finalShuffleStageDef.doesShuffle()) {
                finalShuffleStageDef = null;
            }
            QueryDefinitionBuilder builder = QueryDefinition.builder();
            for (StageDefinition stageDef : queryDef.getStageDefinitions()) {
                if (stageDef.equals(finalShuffleStageDef)) {
                    builder.add(StageDefinition.builder(stageDef).shuffleCheckHasMultipleValues(true));
                    continue;
                }
                builder.add(StageDefinition.builder(stageDef));
            }
            DataSchema dataSchema = ControllerImpl.generateDataSchema(querySpec, querySignature, queryClusterBy, columnMappings, jsonMapper);
            builder.add(StageDefinition.builder(queryDef.getNextStageNumber()).inputs(new StageInputSpec(queryDef.getFinalStageDefinition().getStageNumber())).maxWorkerCount(tuningConfig.getMaxNumWorkers()).processorFactory(new SegmentGeneratorFrameProcessorFactory(dataSchema, columnMappings, tuningConfig)));
            return builder.build();
        }
        if (querySpec.getDestination() instanceof TaskReportMSQDestination) {
            return queryDef;
        }
        throw new ISE("Unsupported destination [%s]", new Object[]{querySpec.getDestination()});
    }

    private static DataSchema generateDataSchema(MSQSpec querySpec, RowSignature querySignature, ClusterBy queryClusterBy, ColumnMappings columnMappings, ObjectMapper jsonMapper) {
        DataSourceMSQDestination destination = (DataSourceMSQDestination)querySpec.getDestination();
        boolean isRollupQuery = ControllerImpl.isRollupQuery(querySpec.getQuery());
        Pair<List<DimensionSchema>, List<AggregatorFactory>> dimensionsAndAggregators = ControllerImpl.makeDimensionsAndAggregatorsForIngestion(querySignature, queryClusterBy, destination.getSegmentSortOrder(), columnMappings, isRollupQuery, querySpec.getQuery());
        return new DataSchema(destination.getDataSource(), new TimestampSpec("__time", "millis", null), new DimensionsSpec((List)dimensionsAndAggregators.lhs), ((List)dimensionsAndAggregators.rhs).toArray(new AggregatorFactory[0]), ControllerImpl.makeGranularitySpecForIngestion(querySpec.getQuery(), querySpec.getColumnMappings(), isRollupQuery, jsonMapper), new TransformSpec(null, Collections.emptyList()));
    }

    private static GranularitySpec makeGranularitySpecForIngestion(Query<?> query, ColumnMappings columnMappings, boolean isRollupQuery, ObjectMapper jsonMapper) {
        if (isRollupQuery) {
            String queryGranularityString = query.context().getString("timestampResultFieldGranularity", "");
            if (ControllerImpl.timeIsGroupByDimension((GroupByQuery)query, columnMappings) && !queryGranularityString.isEmpty()) {
                Granularity queryGranularity;
                try {
                    queryGranularity = (Granularity)jsonMapper.readValue(queryGranularityString, Granularity.class);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                return new ArbitraryGranularitySpec(queryGranularity, Boolean.valueOf(true), (List)Intervals.ONLY_ETERNITY);
            }
            return new ArbitraryGranularitySpec(Granularities.NONE, Boolean.valueOf(true), (List)Intervals.ONLY_ETERNITY);
        }
        return new ArbitraryGranularitySpec(Granularities.NONE, Boolean.valueOf(false), (List)Intervals.ONLY_ETERNITY);
    }

    private static boolean timeIsGroupByDimension(GroupByQuery groupByQuery, ColumnMappings columnMappings) {
        if (columnMappings.hasOutputColumn("__time")) {
            String queryTimeColumn = columnMappings.getQueryColumnForOutputColumn("__time");
            return queryTimeColumn.equals(groupByQuery.context().getString("timestampResultField"));
        }
        return false;
    }

    private static boolean isRollupQuery(Query<?> query) {
        return query instanceof GroupByQuery && !MultiStageQueryContext.isFinalizeAggregations(query.context()) && !query.context().getBoolean("groupByEnableMultiValueUnnesting", true);
    }

    private static boolean isInlineResults(MSQSpec querySpec) {
        return querySpec.getDestination() instanceof TaskReportMSQDestination;
    }

    private static boolean isTimeBucketedIngestion(MSQSpec querySpec) {
        return MSQControllerTask.isIngestion(querySpec) && !((DataSourceMSQDestination)querySpec.getDestination()).getSegmentGranularity().equals(Granularities.ALL);
    }

    private static List<String> computeShardColumns(RowSignature signature, ClusterBy clusterBy, ColumnMappings columnMappings) {
        List clusterByColumns = clusterBy.getColumns();
        ArrayList<String> shardColumns = new ArrayList<String>();
        boolean boosted = ControllerImpl.isClusterByBoosted(clusterBy);
        int numShardColumns = clusterByColumns.size() - clusterBy.getBucketByCount() - (boosted ? 1 : 0);
        if (numShardColumns == 0) {
            return Collections.emptyList();
        }
        for (int i = clusterBy.getBucketByCount(); i < clusterBy.getBucketByCount() + numShardColumns; ++i) {
            SortColumn column = (SortColumn)clusterByColumns.get(i);
            List<String> outputColumns = columnMappings.getOutputColumnsForQueryColumn(column.columnName());
            if (column.descending()) {
                return Collections.emptyList();
            }
            ColumnType columnType = signature.getColumnType(column.columnName()).orElse(null);
            if (!ColumnType.STRING.equals((Object)columnType)) {
                return Collections.emptyList();
            }
            if (outputColumns.isEmpty()) {
                return Collections.emptyList();
            }
            shardColumns.add(outputColumns.get(0));
        }
        return shardColumns;
    }

    private static boolean isClusterByBoosted(ClusterBy clusterBy) {
        return !clusterBy.getColumns().isEmpty() && ((SortColumn)clusterBy.getColumns().get(clusterBy.getColumns().size() - 1)).columnName().equals("__boost");
    }

    private static StringTuple makeStringTuple(ClusterBy clusterBy, RowKeyReader keyReader, RowKey key) {
        String[] array = new String[clusterBy.getColumns().size() - clusterBy.getBucketByCount()];
        boolean boosted = ControllerImpl.isClusterByBoosted(clusterBy);
        for (int i = 0; i < array.length; ++i) {
            Object val = keyReader.read(key, clusterBy.getBucketByCount() + i);
            array[i] = i == array.length - 1 && boosted ? StringUtils.format((String)"%016d", (Object[])new Object[]{(long)((Long)val)}) : (String)val;
        }
        return new StringTuple(array);
    }

    private static Pair<List<DimensionSchema>, List<AggregatorFactory>> makeDimensionsAndAggregatorsForIngestion(RowSignature querySignature, ClusterBy queryClusterBy, List<String> segmentSortOrder, ColumnMappings columnMappings, boolean isRollupQuery, Query<?> query) {
        ArrayList<DimensionSchema> dimensions = new ArrayList<DimensionSchema>();
        ArrayList<AggregatorFactory> aggregators = new ArrayList<AggregatorFactory>();
        LinkedHashSet<String> outputColumnsInOrder = new LinkedHashSet<String>(segmentSortOrder);
        for (SortColumn clusterByColumn : queryClusterBy.getColumns()) {
            if (clusterByColumn.descending()) {
                throw new MSQException(new InsertCannotOrderByDescendingFault(clusterByColumn.columnName()));
            }
            outputColumnsInOrder.addAll(columnMappings.getOutputColumnsForQueryColumn(clusterByColumn.columnName()));
        }
        outputColumnsInOrder.addAll(columnMappings.getOutputColumnNames());
        HashMap<String, AggregatorFactory> outputColumnAggregatorFactories = new HashMap<String, AggregatorFactory>();
        if (isRollupQuery) {
            for (AggregatorFactory aggregatorFactory : ((GroupByQuery)query).getAggregatorSpecs()) {
                String outputColumn = (String)Iterables.getOnlyElement(columnMappings.getOutputColumnsForQueryColumn(aggregatorFactory.getName()));
                if (outputColumnAggregatorFactories.containsKey(outputColumn)) {
                    throw new ISE("There can only be one aggregator factory for column [%s].", new Object[]{outputColumn});
                }
                outputColumnAggregatorFactories.put(outputColumn, aggregatorFactory.withName(outputColumn).getCombiningFactory());
            }
        }
        for (String outputColumn : outputColumnsInOrder) {
            String queryColumn = columnMappings.getQueryColumnForOutputColumn(outputColumn);
            ColumnType type = (ColumnType)querySignature.getColumnType(queryColumn).orElseThrow(() -> new ISE("No type for column [%s]", new Object[]{outputColumn}));
            if (outputColumn.equals("__time")) continue;
            if (!type.is((TypeDescriptor)ValueType.COMPLEX)) {
                ControllerImpl.populateDimensionsAndAggregators(dimensions, aggregators, outputColumnAggregatorFactories, outputColumn, type);
                continue;
            }
            if (DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.containsKey(type.getComplexTypeName())) {
                dimensions.add(DimensionSchemaUtils.createDimensionSchema(outputColumn, type));
                continue;
            }
            if (!isRollupQuery) {
                aggregators.add(new PassthroughAggregatorFactory(outputColumn, type.getComplexTypeName()));
                continue;
            }
            ControllerImpl.populateDimensionsAndAggregators(dimensions, aggregators, outputColumnAggregatorFactories, outputColumn, type);
        }
        return Pair.of(dimensions, aggregators);
    }

    private static void populateDimensionsAndAggregators(List<DimensionSchema> dimensions, List<AggregatorFactory> aggregators, Map<String, AggregatorFactory> outputColumnAggregatorFactories, String outputColumn, ColumnType type) {
        if (outputColumnAggregatorFactories.containsKey(outputColumn)) {
            aggregators.add(outputColumnAggregatorFactories.get(outputColumn));
        } else {
            dimensions.add(DimensionSchemaUtils.createDimensionSchema(outputColumn, type));
        }
    }

    private static DateTime getBucketDateTime(ClusterByPartition partitionBoundary, Granularity segmentGranularity, RowKeyReader keyReader) {
        if (Granularities.ALL.equals(segmentGranularity)) {
            return DateTimes.utc((long)0L);
        }
        RowKey startKey = partitionBoundary.getStart();
        DateTime timestamp = DateTimes.utc((long)MSQTasks.primaryTimestampFromObjectForInsert(keyReader.read(startKey, 0)));
        if (segmentGranularity.bucketStart(timestamp.getMillis()) != timestamp.getMillis()) {
            throw new ISE("Received boundary value [%s] misaligned with segmentGranularity [%s]", new Object[]{timestamp, segmentGranularity});
        }
        return timestamp;
    }

    private static MSQStagesReport makeStageReport(QueryDefinition queryDef, Map<Integer, ControllerStagePhase> stagePhaseMap, Map<Integer, Interval> stageRuntimeMap, Map<Integer, Integer> stageWorkerCountMap, Map<Integer, Integer> stagePartitionCountMap) {
        return MSQStagesReport.create(queryDef, (Map<Integer, ControllerStagePhase>)ImmutableMap.copyOf(stagePhaseMap), ControllerImpl.copyOfStageRuntimesEndingAtCurrentTime(stageRuntimeMap), stageWorkerCountMap, stagePartitionCountMap);
    }

    private static MSQResultsReport makeResultsTaskReport(QueryDefinition queryDef, Yielder<Object[]> resultsYielder, ColumnMappings columnMappings, @Nullable List<String> sqlTypeNames) {
        RowSignature querySignature = queryDef.getFinalStageDefinition().getSignature();
        RowSignature.Builder mappedSignature = RowSignature.builder();
        for (ColumnMapping mapping : columnMappings.getMappings()) {
            mappedSignature.add(mapping.getOutputColumn(), (ColumnType)querySignature.getColumnType(mapping.getQueryColumn()).orElse(null));
        }
        return new MSQResultsReport(mappedSignature.build(), sqlTypeNames, resultsYielder);
    }

    private static MSQStatusReport makeStatusReport(TaskState taskState, @Nullable MSQErrorReport errorReport, Queue<MSQErrorReport> errorReports, @Nullable DateTime queryStartTime, long queryDuration, MSQWorkerTaskLauncher taskLauncher) {
        int pendingTasks = -1;
        int runningTasks = 1;
        if (taskLauncher != null) {
            WorkerCount workerTaskCount = taskLauncher.getWorkerTaskCount();
            pendingTasks = workerTaskCount.getPendingWorkerCount();
            runningTasks = workerTaskCount.getRunningWorkerCount() + 1;
        }
        return new MSQStatusReport(taskState, errorReport, errorReports, queryStartTime, queryDuration, pendingTasks, runningTasks);
    }

    private static InputSpecSlicerFactory makeInputSpecSlicerFactory(DataSegmentTimelineView timelineView) {
        return stagePartitionsMap -> new MapInputSpecSlicer((Map<Class<? extends InputSpec>, InputSpecSlicer>)ImmutableMap.builder().put(StageInputSpec.class, (Object)new StageInputSpecSlicer((Int2ObjectMap<ReadablePartitions>)stagePartitionsMap)).put(ExternalInputSpec.class, (Object)new ExternalInputSpecSlicer()).put(TableInputSpec.class, (Object)new TableInputSpecSlicer(timelineView)).build());
    }

    private static Map<Integer, Interval> copyOfStageRuntimesEndingAtCurrentTime(Map<Integer, Interval> stageRuntimesMap) {
        Int2ObjectOpenHashMap retVal = new Int2ObjectOpenHashMap(stageRuntimesMap.size());
        DateTime now = DateTimes.nowUtc();
        for (Map.Entry<Integer, Interval> entry : stageRuntimesMap.entrySet()) {
            int stageNumber = entry.getKey();
            Interval interval = entry.getValue();
            retVal.put(stageNumber, (Object)(interval.getEnd().equals((Object)DateTimes.MAX) ? new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)now) : interval));
        }
        return retVal;
    }

    static void performSegmentPublish(TaskActionClient client, SegmentTransactionalInsertAction action) throws IOException {
        try {
            SegmentPublishResult result = (SegmentPublishResult)client.submit((TaskAction)action);
            if (!result.isSuccess()) {
                throw new MSQException(InsertLockPreemptedFault.instance());
            }
        }
        catch (Exception e) {
            if (ControllerImpl.isTaskLockPreemptedException(e)) {
                throw new MSQException(e, InsertLockPreemptedFault.instance());
            }
            throw e;
        }
    }

    private static boolean isTaskLockPreemptedException(Exception e) {
        String exceptionMsg = e.getMessage();
        if (exceptionMsg == null) {
            return false;
        }
        ImmutableList validExceptionExcerpts = ImmutableList.of((Object)"are not covered by locks", (Object)"is preempted and no longer valid");
        return validExceptionExcerpts.stream().anyMatch(exceptionMsg::contains);
    }

    private static void logKernelStatus(String queryId, ControllerQueryKernel queryKernel) {
        if (log.isDebugEnabled()) {
            log.debug("Query [%s] kernel state: %s", new Object[]{queryId, queryKernel.getActiveStages().stream().sorted(Comparator.comparing(id -> queryKernel.getStageDefinition((StageId)id).getStageNumber())).map(id -> StringUtils.format((String)"%d:%d[%s:%s]>%s", (Object[])new Object[]{queryKernel.getStageDefinition((StageId)id).getStageNumber(), queryKernel.getWorkerInputsForStage((StageId)id).workerCount(), queryKernel.getStageDefinition((StageId)id).doesShuffle() ? "SHUFFLE" : "RETAIN", queryKernel.getStagePhase((StageId)id), queryKernel.doesStageHaveResultPartitions((StageId)id) ? Integer.valueOf(Iterators.size(queryKernel.getResultPartitionsForStage((StageId)id).iterator())) : "?"})).collect(Collectors.joining("; "))});
        }
    }

    private static interface TaskContactFn {
        public ListenableFuture<Void> contactTask(WorkerClient var1, String var2, int var3);
    }

    private class RunQueryUntilDone {
        private final QueryDefinition queryDef;
        private final InputSpecSlicerFactory inputSpecSlicerFactory;
        private final Closer closer;
        private final ControllerQueryKernel queryKernel;
        private final Set<StageId> stageResultPartitionBoundariesSent = new HashSet<StageId>();
        private ListenableFuture<?> workerTaskLauncherFuture;
        private List<SegmentIdWithShardSpec> segmentsToGenerate;

        public RunQueryUntilDone(QueryDefinition queryDef, InputSpecSlicerFactory inputSpecSlicerFactory, Closer closer) {
            this.queryDef = queryDef;
            this.inputSpecSlicerFactory = inputSpecSlicerFactory;
            this.closer = closer;
            this.queryKernel = new ControllerQueryKernel(queryDef);
        }

        private Pair<ControllerQueryKernel, ListenableFuture<?>> run() throws IOException, InterruptedException {
            this.startTaskLauncher();
            while (!this.queryKernel.isDone()) {
                this.startStages();
                this.sendPartitionBoundaries();
                this.updateLiveReportMaps();
                this.cleanUpEffectivelyFinishedStages();
                this.runKernelCommands();
            }
            if (!this.queryKernel.isSuccess()) {
                this.throwKernelExceptionIfNotUnknown();
            }
            this.cleanUpEffectivelyFinishedStages();
            return Pair.of((Object)this.queryKernel, this.workerTaskLauncherFuture);
        }

        private void runKernelCommands() throws InterruptedException {
            if (!this.queryKernel.isDone()) {
                Consumer command = (Consumer)ControllerImpl.this.kernelManipulationQueue.take();
                command.accept(this.queryKernel);
                while ((command = (Consumer)ControllerImpl.this.kernelManipulationQueue.poll()) != null) {
                    command.accept(this.queryKernel);
                }
            }
        }

        private void startTaskLauncher() {
            log.debug("Query [%s] starting task launcher.", new Object[]{this.queryDef.getQueryId()});
            this.workerTaskLauncherFuture = ControllerImpl.this.workerTaskLauncher.start();
            this.closer.register(() -> ControllerImpl.this.workerTaskLauncher.stop(true));
            this.workerTaskLauncherFuture.addListener(() -> ControllerImpl.this.addToKernelManipulationQueue(queryKernel -> FutureUtils.getUncheckedImmediately(this.workerTaskLauncherFuture)), (Executor)Execs.directExecutor());
        }

        private void startStages() throws IOException, InterruptedException {
            ControllerImpl.logKernelStatus(this.queryDef.getQueryId(), this.queryKernel);
            List<StageId> newStageIds = this.queryKernel.createAndGetNewStageIds(this.inputSpecSlicerFactory, ControllerImpl.this.task.getQuerySpec().getAssignmentStrategy());
            for (StageId stageId : newStageIds) {
                this.queryKernel.startStage(stageId);
                if (MSQControllerTask.isIngestion(ControllerImpl.this.task.getQuerySpec()) && stageId.getStageNumber() == this.queryDef.getFinalStageDefinition().getStageNumber()) {
                    int shuffleStageNumber = (Integer)Iterables.getOnlyElement((Iterable)this.queryDef.getFinalStageDefinition().getInputStageNumbers());
                    while (!this.queryDef.getStageDefinition(shuffleStageNumber).doesShuffle()) {
                        shuffleStageNumber = (Integer)Iterables.getOnlyElement((Iterable)this.queryDef.getStageDefinition(shuffleStageNumber).getInputStageNumbers());
                    }
                    StageId shuffleStageId = new StageId(this.queryDef.getQueryId(), shuffleStageNumber);
                    boolean isTimeBucketed = ControllerImpl.isTimeBucketedIngestion(ControllerImpl.this.task.getQuerySpec());
                    ClusterByPartitions partitionBoundaries = this.queryKernel.getResultPartitionBoundariesForStage(shuffleStageId);
                    if (isTimeBucketed && partitionBoundaries.equals((Object)ClusterByPartitions.oneUniversalPartition())) {
                        throw new MSQException(new InsertCannotBeEmptyFault(ControllerImpl.this.task.getDataSource()));
                    }
                    log.info("Query [%s] generating %d segments.", new Object[]{this.queryDef.getQueryId(), partitionBoundaries.size()});
                    boolean mayHaveMultiValuedClusterByFields = !this.queryKernel.getStageDefinition(shuffleStageId).mustGatherResultKeyStatistics() || this.queryKernel.hasStageCollectorEncounteredAnyMultiValueField(shuffleStageId);
                    this.segmentsToGenerate = ControllerImpl.this.generateSegmentIdsWithShardSpecs((DataSourceMSQDestination)ControllerImpl.this.task.getQuerySpec().getDestination(), this.queryKernel.getStageDefinition(shuffleStageId).getSignature(), this.queryKernel.getStageDefinition(shuffleStageId).getShuffleSpec().get().getClusterBy(), partitionBoundaries, mayHaveMultiValuedClusterByFields);
                }
                int workerCount = this.queryKernel.getWorkerInputsForStage(stageId).workerCount();
                log.info("Query [%s] starting %d workers for stage %d.", new Object[]{stageId.getQueryId(), workerCount, stageId.getStageNumber()});
                ControllerImpl.this.workerTaskLauncher.launchTasksIfNeeded(workerCount);
                ControllerImpl.this.stageRuntimesForLiveReports.put(stageId.getStageNumber(), new Interval((ReadableInstant)DateTimes.nowUtc(), (ReadableInstant)DateTimes.MAX));
                ControllerImpl.this.startWorkForStage(this.queryDef, this.queryKernel, stageId.getStageNumber(), this.segmentsToGenerate);
            }
        }

        private void sendPartitionBoundaries() {
            ControllerImpl.logKernelStatus(this.queryDef.getQueryId(), this.queryKernel);
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                if (!this.queryKernel.getStageDefinition(stageId).mustGatherResultKeyStatistics() || !this.queryKernel.doesStageHaveResultPartitions(stageId) || !this.stageResultPartitionBoundariesSent.add(stageId)) continue;
                if (log.isDebugEnabled()) {
                    ClusterByPartitions partitions = this.queryKernel.getResultPartitionBoundariesForStage(stageId);
                    log.debug("Query [%s] sending out partition boundaries for stage %d: %s", new Object[]{stageId.getQueryId(), stageId.getStageNumber(), IntStream.range(0, partitions.size()).mapToObj(i -> StringUtils.format((String)"%s:%s", (Object[])new Object[]{i, partitions.get(i)})).collect(Collectors.joining(", "))});
                } else {
                    log.info("Query [%s] sending out partition boundaries for stage %d.", new Object[]{stageId.getQueryId(), stageId.getStageNumber()});
                }
                ControllerImpl.this.postResultPartitionBoundariesForStage(this.queryDef, stageId.getStageNumber(), this.queryKernel.getResultPartitionBoundariesForStage(stageId), this.queryKernel.getWorkerInputsForStage(stageId).workers());
            }
        }

        private void updateLiveReportMaps() {
            ControllerImpl.logKernelStatus(this.queryDef.getQueryId(), this.queryKernel);
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                int stageNumber = stageId.getStageNumber();
                ControllerImpl.this.stagePhasesForLiveReports.put(stageNumber, this.queryKernel.getStagePhase(stageId));
                if (this.queryKernel.doesStageHaveResultPartitions(stageId)) {
                    ControllerImpl.this.stagePartitionCountsForLiveReports.computeIfAbsent(stageNumber, k -> Iterators.size(this.queryKernel.getResultPartitionsForStage(stageId).iterator()));
                }
                ControllerImpl.this.stageWorkerCountsForLiveReports.putIfAbsent(stageNumber, this.queryKernel.getWorkerInputsForStage(stageId).workerCount());
            }
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                if (!ControllerStagePhase.isSuccessfulTerminalPhase(this.queryKernel.getStagePhase(stageId))) continue;
                ControllerImpl.this.stageRuntimesForLiveReports.compute(this.queryKernel.getStageDefinition(stageId).getStageNumber(), (k, currentValue) -> {
                    if (currentValue.getEnd().equals((Object)DateTimes.MAX)) {
                        return new Interval((ReadableInstant)currentValue.getStart(), (ReadableInstant)DateTimes.nowUtc());
                    }
                    return currentValue;
                });
            }
        }

        private void cleanUpEffectivelyFinishedStages() {
            for (StageId stageId : this.queryKernel.getEffectivelyFinishedStageIds()) {
                log.info("Query [%s] issuing cleanup order for stage %d.", new Object[]{this.queryDef.getQueryId(), stageId.getStageNumber()});
                ControllerImpl.this.contactWorkersForStage((netClient, taskId, workerNumber) -> netClient.postCleanupStage(taskId, stageId), this.queryKernel.getWorkerInputsForStage(stageId).workers());
                this.queryKernel.finishStage(stageId, true);
            }
        }

        private void throwKernelExceptionIfNotUnknown() {
            for (StageId stageId : this.queryKernel.getActiveStages()) {
                MSQFault fault;
                if (this.queryKernel.getStagePhase(stageId) != ControllerStagePhase.FAILED || "UnknownError".equals((fault = this.queryKernel.getFailureReasonForStage(stageId)).getErrorCode())) continue;
                throw new MSQException(fault);
            }
        }
    }
}

