/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterSnapshots;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;
import org.apache.druid.msq.counters.SuperSorterProgressTrackerCounter;
import org.apache.druid.msq.counters.WarningCounters;

public class CounterTracker {
    private final ConcurrentHashMap<String, QueryCounter> countersMap = new ConcurrentHashMap();

    public ChannelCounters channel(String name) {
        return this.counter(name, ChannelCounters::new);
    }

    public SuperSorterProgressTracker sortProgress() {
        return this.counter(CounterNames.sortProgress(), SuperSorterProgressTrackerCounter::new).tracker();
    }

    public WarningCounters warnings() {
        return this.counter(CounterNames.warnings(), WarningCounters::new);
    }

    public <T extends QueryCounter> T counter(String counterName, Supplier<T> newCounterFn) {
        return (T)this.countersMap.computeIfAbsent(counterName, ignored -> (QueryCounter)newCounterFn.get());
    }

    public CounterSnapshots snapshot() {
        HashMap<String, QueryCounterSnapshot> m = new HashMap<String, QueryCounterSnapshot>();
        for (Map.Entry<String, QueryCounter> entry : this.countersMap.entrySet()) {
            QueryCounterSnapshot counterSnapshot = entry.getValue().snapshot();
            if (counterSnapshot == null) continue;
            m.put(entry.getKey(), counterSnapshot);
        }
        return new CounterSnapshots(m);
    }
}

