/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.ordering.StringComparators;

public class CounterNames {
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String SHUFFLE = "shuffle";
    private static final String SORT_PROGRESS = "sortProgress";
    private static final String WARNINGS = "warnings";
    private static final Comparator<String> COMPARATOR = new NameComparator();

    private CounterNames() {
    }

    public static String inputChannel(int inputNumber) {
        return StringUtils.format((String)"%s%d", (Object[])new Object[]{INPUT, inputNumber});
    }

    public static String outputChannel() {
        return OUTPUT;
    }

    public static String shuffleChannel() {
        return SHUFFLE;
    }

    public static String sortProgress() {
        return SORT_PROGRESS;
    }

    public static String warnings() {
        return WARNINGS;
    }

    public static Comparator<String> comparator() {
        return COMPARATOR;
    }

    private static class NameComparator
    implements Comparator<String> {
        private static final Map<String, Integer> ORDER = ImmutableMap.builder().put((Object)"output", (Object)0).put((Object)"shuffle", (Object)1).put((Object)"sortProgress", (Object)2).put((Object)"warnings", (Object)3).build();

        private NameComparator() {
        }

        @Override
        public int compare(String name1, String name2) {
            boolean isInput1 = name1.startsWith(CounterNames.INPUT);
            boolean isInput2 = name2.startsWith(CounterNames.INPUT);
            if (isInput1 && isInput2) {
                return StringComparators.ALPHANUMERIC.compare((Object)name1, (Object)name2);
            }
            if (isInput1 != isInput2) {
                return isInput1 ? -1 : 1;
            }
            assert (!isInput1 && !isInput2);
            Integer order1 = ORDER.get(name1);
            Integer order2 = ORDER.get(name2);
            if (order1 != null && order2 != null) {
                return Integer.compare(order1, order2);
            }
            if (order1 != null) {
                return -1;
            }
            if (order2 != null) {
                return 1;
            }
            assert (order1 == null && order2 == null);
            return name1.compareTo(name2);
        }
    }
}

