/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;

public class ChannelCounters
implements QueryCounter {
    private static final int NO_PARTITION = 0;
    @GuardedBy(value="this")
    private final LongList rows = new LongArrayList();
    @GuardedBy(value="this")
    private final LongList bytes = new LongArrayList();
    @GuardedBy(value="this")
    private final LongList frames = new LongArrayList();
    @GuardedBy(value="this")
    private final LongList files = new LongArrayList();
    @GuardedBy(value="this")
    private final LongList totalFiles = new LongArrayList();

    public void incrementRowCount() {
        this.add(0, 1L, 0L, 0L, 0L);
    }

    public void incrementFileCount() {
        this.add(0, 0L, 0L, 0L, 1L);
    }

    public void addFile(long nRows, long nBytes) {
        this.add(0, nRows, nBytes, 0L, 1L);
    }

    public void addFrame(int partitionNumber, Frame frame) {
        this.add(partitionNumber, frame.numRows(), frame.numBytes(), 1L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelCounters setTotalFiles(long nFiles) {
        ChannelCounters channelCounters = this;
        synchronized (channelCounters) {
            this.ensureCapacityForPartition(0);
            this.totalFiles.set(0, nFiles);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(int partitionNumber, long nRows, long nBytes, long nFrames, long nFiles) {
        ChannelCounters channelCounters = this;
        synchronized (channelCounters) {
            this.ensureCapacityForPartition(partitionNumber);
            this.rows.set(partitionNumber, this.rows.getLong(partitionNumber) + nRows);
            this.bytes.set(partitionNumber, this.bytes.getLong(partitionNumber) + nBytes);
            this.frames.set(partitionNumber, this.frames.getLong(partitionNumber) + nFrames);
            this.files.set(partitionNumber, this.files.getLong(partitionNumber) + nFiles);
        }
    }

    @GuardedBy(value="this")
    private void ensureCapacityForPartition(int partitionNumber) {
        while (partitionNumber >= this.rows.size()) {
            this.rows.add(0L);
        }
        while (partitionNumber >= this.bytes.size()) {
            this.bytes.add(0L);
        }
        while (partitionNumber >= this.frames.size()) {
            this.frames.add(0L);
        }
        while (partitionNumber >= this.files.size()) {
            this.files.add(0L);
        }
        while (partitionNumber >= this.totalFiles.size()) {
            this.totalFiles.add(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Snapshot snapshot() {
        long[] totalFilesArray;
        long[] filesArray;
        long[] framesArray;
        long[] bytesArray;
        long[] rowsArray;
        ChannelCounters channelCounters = this;
        synchronized (channelCounters) {
            rowsArray = ChannelCounters.listToArray(this.rows);
            bytesArray = ChannelCounters.listToArray(this.bytes);
            framesArray = ChannelCounters.listToArray(this.frames);
            filesArray = ChannelCounters.listToArray(this.files);
            totalFilesArray = ChannelCounters.listToArray(this.totalFiles);
        }
        if (rowsArray == null && bytesArray == null && framesArray == null && filesArray == null && totalFilesArray == null) {
            return null;
        }
        return new Snapshot(rowsArray, bytesArray, framesArray, filesArray, totalFilesArray);
    }

    @Nullable
    private static long[] listToArray(LongList longList) {
        boolean allZero = true;
        for (int i = 0; i < longList.size(); ++i) {
            if (longList.getLong(i) == 0L) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            return null;
        }
        return longList.toArray(new long[0]);
    }

    @JsonTypeName(value="channel")
    public static class Snapshot
    implements QueryCounterSnapshot {
        private final long[] rows;
        private final long[] bytes;
        private final long[] frames;
        private final long[] files;
        private final long[] totalFiles;

        @JsonCreator
        public Snapshot(@Nullable @JsonProperty(value="rows") long[] rows, @Nullable @JsonProperty(value="bytes") long[] bytes, @Nullable @JsonProperty(value="frames") long[] frames, @Nullable @JsonProperty(value="files") long[] files, @Nullable @JsonProperty(value="totalFiles") long[] totalFiles) {
            this.rows = rows;
            this.bytes = bytes;
            this.frames = frames;
            this.files = files;
            this.totalFiles = totalFiles;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public long[] getRows() {
            return this.rows;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public long[] getBytes() {
            return this.bytes;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public long[] getFrames() {
            return this.frames;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public long[] getFiles() {
            return this.files;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public long[] getTotalFiles() {
            return this.totalFiles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return Arrays.equals(this.rows, snapshot.rows) && Arrays.equals(this.bytes, snapshot.bytes) && Arrays.equals(this.frames, snapshot.frames) && Arrays.equals(this.files, snapshot.files) && Arrays.equals(this.totalFiles, snapshot.totalFiles);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.rows);
            result = 31 * result + Arrays.hashCode(this.bytes);
            result = 31 * result + Arrays.hashCode(this.frames);
            result = 31 * result + Arrays.hashCode(this.files);
            result = 31 * result + Arrays.hashCode(this.totalFiles);
            return result;
        }

        public String toString() {
            return "ChannelCounters.Snapshot{rows=" + Arrays.toString(this.rows) + ", bytes=" + Arrays.toString(this.bytes) + ", frames=" + Arrays.toString(this.frames) + ", files=" + Arrays.toString(this.files) + ", totalFiles=" + Arrays.toString(this.totalFiles) + '}';
        }
    }
}

