/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.avro.mapred.tether.TetherInputFormat;
import org.apache.avro.mapred.tether.TetherKeyComparator;
import org.apache.avro.mapred.tether.TetherKeySerialization;
import org.apache.avro.mapred.tether.TetherMapRunner;
import org.apache.avro.mapred.tether.TetherOutputFormat;
import org.apache.avro.mapred.tether.TetherPartitioner;
import org.apache.avro.mapred.tether.TetherReducer;
import org.apache.avro.mapred.tether.TetheredProcess;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class TetherJob
extends Configured {
    public static final String TETHER_EXEC = "avro.tether.executable";
    public static final String TETHER_EXEC_ARGS = "avro.tether.executable_args";
    public static final String TETHER_EXEC_CACHED = "avro.tether.executable_cached";
    public static final String TETHER_PROTOCOL = "avro.tether.protocol";

    public static URI getExecutable(JobConf job) {
        try {
            return new URI(job.get(TETHER_EXEC));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setExecutable(JobConf job, File executable) {
        TetherJob.setExecutable(job, executable, new ArrayList<String>(), false);
    }

    public static void setExecutable(JobConf job, File executable, List<String> args, boolean cached) {
        job.set(TETHER_EXEC, executable.toString());
        if (args != null) {
            StringBuilder sb = new StringBuilder();
            for (String a : args) {
                sb.append(a);
                sb.append('\n');
            }
            job.set(TETHER_EXEC_ARGS, sb.toString());
        }
        job.set(TETHER_EXEC_CACHED, Boolean.valueOf(cached).toString());
    }

    public static TetheredProcess.Protocol getProtocol(JobConf job) {
        if (job.get(TETHER_PROTOCOL) == null) {
            return TetheredProcess.Protocol.NONE;
        }
        if (job.get(TETHER_PROTOCOL).equals("http")) {
            return TetheredProcess.Protocol.HTTP;
        }
        if (job.get(TETHER_PROTOCOL).equals("sasl")) {
            return TetheredProcess.Protocol.SASL;
        }
        throw new RuntimeException("Unknown value for protocol: " + job.get(TETHER_PROTOCOL));
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        TetherJob.setupTetherJob(job);
        return JobClient.runJob((JobConf)job);
    }

    public static RunningJob submitJob(JobConf conf) throws IOException {
        TetherJob.setupTetherJob(conf);
        return new JobClient(conf).submitJob(conf);
    }

    public static void setProtocol(JobConf job, String proto) throws IOException {
        if (!(proto = proto.trim().toLowerCase()).equals("http") && !proto.equals("sasl")) {
            throw new IOException("protocol must be 'http' or 'sasl'");
        }
        job.set(TETHER_PROTOCOL, proto);
    }

    private static void setupTetherJob(JobConf job) throws IOException {
        Collection serializations;
        job.setMapRunnerClass(TetherMapRunner.class);
        job.setPartitionerClass(TetherPartitioner.class);
        job.setReducerClass(TetherReducer.class);
        job.setInputFormat(TetherInputFormat.class);
        job.setOutputFormat(TetherOutputFormat.class);
        job.setOutputKeyClass(TetherData.class);
        job.setOutputKeyComparatorClass(TetherKeyComparator.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setMapOutputKeyClass(TetherData.class);
        if (job.getStrings(TETHER_PROTOCOL) == null) {
            job.set(TETHER_PROTOCOL, "sasl");
        }
        if (!(serializations = job.getStringCollection("io.serializations")).contains(TetherKeySerialization.class.getName())) {
            serializations.add(TetherKeySerialization.class.getName());
            job.setStrings("io.serializations", serializations.toArray(new String[0]));
        }
        if (job.getBoolean(TETHER_EXEC_CACHED, false)) {
            DistributedCache.addCacheFile((URI)TetherJob.getExecutable(job), (Configuration)job);
        }
    }
}

