/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Set;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.server.metrics.WorkerTaskCountStatsProvider;

public class WorkerTaskCountStatsMonitor
extends AbstractMonitor {
    private final WorkerTaskCountStatsProvider statsProvider;
    private final String workerCategory;
    private final String workerVersion;
    private final boolean isMiddleManager;

    @Inject
    public WorkerTaskCountStatsMonitor(Injector injector, @Self Set<NodeRole> nodeRoles) {
        this.isMiddleManager = nodeRoles.contains(NodeRole.MIDDLE_MANAGER);
        if (this.isMiddleManager) {
            this.statsProvider = (WorkerTaskCountStatsProvider)injector.getInstance(WorkerTaskCountStatsProvider.class);
            this.workerCategory = this.statsProvider.getWorkerCategory();
            this.workerVersion = this.statsProvider.getWorkerVersion();
        } else {
            this.statsProvider = null;
            this.workerCategory = null;
            this.workerVersion = null;
        }
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.isMiddleManager) {
            this.emit(emitter, "worker/task/failed/count", this.statsProvider.getWorkerFailedTaskCount());
            this.emit(emitter, "worker/task/success/count", this.statsProvider.getWorkerSuccessfulTaskCount());
            this.emit(emitter, "worker/taskSlot/idle/count", this.statsProvider.getWorkerIdleTaskSlotCount());
            this.emit(emitter, "worker/taskSlot/total/count", this.statsProvider.getWorkerTotalTaskSlotCount());
            this.emit(emitter, "worker/taskSlot/used/count", this.statsProvider.getWorkerUsedTaskSlotCount());
        }
        return true;
    }

    private void emit(ServiceEmitter emitter, String metricName, Long value) {
        if (value != null) {
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            builder.setDimension("category", (Object)this.workerCategory);
            builder.setDimension("workerVersion", (Object)this.workerVersion);
            emitter.emit(builder.build(metricName, (Number)value));
        }
    }
}

