/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import javax.ws.rs.core.PathSegment;
import org.apache.druid.server.http.security.AbstractResourceFilter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

public class DatasourceResourceFilter
extends AbstractResourceFilter {
    @Inject
    public DatasourceResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        ResourceAction resourceAction = new ResourceAction(new Resource(this.getRequestDatasourceName(request), "DATASOURCE"), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction(this.getReq(), resourceAction, this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }

    private String getRequestDatasourceName(ContainerRequest request) {
        String dataSourceName = ((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

            public boolean apply(PathSegment input) {
                return "datasources".equals(input.getPath());
            }
        }) + 1)).getPath();
        Preconditions.checkNotNull((Object)dataSourceName);
        return dataSourceName;
    }
}

