/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.JettyUtils;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentWithOvershadowedStatus;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/metadata")
public class MetadataResource {
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public MetadataResource(SegmentsMetadataManager segmentsMetadataManager, IndexerMetadataStorageCoordinator metadataStorageCoordinator, AuthorizerMapper authorizerMapper, @Json ObjectMapper jsonMapper) {
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
        this.authorizerMapper = authorizerMapper;
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDataSources(@QueryParam(value="full") String full, @Context UriInfo uriInfo, @Context HttpServletRequest req) {
        TreeSet dataSourceNamesPreAuth;
        boolean includeUnused = JettyUtils.getQueryParam(uriInfo, "includeUnused", "includeDisabled") != null;
        Collection<ImmutableDruidDataSource> druidDataSources = null;
        if (includeUnused) {
            dataSourceNamesPreAuth = new TreeSet(this.segmentsMetadataManager.retrieveAllDataSourceNames());
        } else {
            druidDataSources = this.segmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments();
            dataSourceNamesPreAuth = druidDataSources.stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toCollection(TreeSet::new));
        }
        TreeSet dataSourceNamesPostAuth = new TreeSet();
        Function raGenerator = datasourceName -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply(datasourceName));
        Iterables.addAll(dataSourceNamesPostAuth, AuthorizationUtils.filterAuthorizedResources(req, dataSourceNamesPreAuth, raGenerator, this.authorizerMapper));
        if (full != null && !includeUnused) {
            return Response.ok().entity((Object)Collections2.filter(druidDataSources, dataSource -> dataSourceNamesPostAuth.contains(dataSource.getName()))).build();
        }
        return Response.ok().entity(dataSourceNamesPostAuth).build();
    }

    @GET
    @Path(value="/segments")
    @Produces(value={"application/json"})
    public Response getAllUsedSegments(@Context HttpServletRequest req, @QueryParam(value="datasources") @Nullable Set<String> dataSources, @QueryParam(value="includeOvershadowedStatus") @Nullable String includeOvershadowedStatus) {
        if (includeOvershadowedStatus != null) {
            return this.getAllUsedSegmentsWithOvershadowedStatus(req, dataSources);
        }
        Collection dataSourcesWithUsedSegments = this.segmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments();
        if (dataSources != null && !dataSources.isEmpty()) {
            dataSourcesWithUsedSegments = dataSourcesWithUsedSegments.stream().filter(dataSourceWithUsedSegments -> dataSources.contains(dataSourceWithUsedSegments.getName())).collect(Collectors.toList());
        }
        Stream usedSegments = dataSourcesWithUsedSegments.stream().flatMap(t -> t.getSegments().stream());
        Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
        Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources(req, usedSegments::iterator, raGenerator, this.authorizerMapper);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        return builder.entity(authorizedSegments).build();
    }

    private Response getAllUsedSegmentsWithOvershadowedStatus(HttpServletRequest req, @Nullable Set<String> dataSources) {
        DataSourcesSnapshot dataSourcesSnapshot = this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments();
        Collection dataSourcesWithUsedSegments = dataSourcesSnapshot.getDataSourcesWithAllUsedSegments();
        if (dataSources != null && !dataSources.isEmpty()) {
            dataSourcesWithUsedSegments = dataSourcesWithUsedSegments.stream().filter(dataSourceWithUsedSegments -> dataSources.contains(dataSourceWithUsedSegments.getName())).collect(Collectors.toList());
        }
        Stream<SegmentWithOvershadowedStatus> usedSegments = dataSourcesWithUsedSegments.stream().flatMap(t -> t.getSegments().stream());
        ImmutableSet<DataSegment> overshadowedSegments = dataSourcesSnapshot.getOvershadowedSegments();
        Stream<SegmentWithOvershadowedStatus> usedSegmentsWithOvershadowedStatus = usedSegments.map(segment -> new SegmentWithOvershadowedStatus(segment, overshadowedSegments.contains(segment)));
        Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSegment().getDataSource()));
        Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources(req, usedSegmentsWithOvershadowedStatus::iterator, raGenerator, this.authorizerMapper);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        return builder.entity(authorizedSegments).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDataSourceWithUsedSegments(@PathParam(value="dataSourceName") String dataSourceName) {
        ImmutableDruidDataSource dataSource = this.segmentsMetadataManager.getImmutableDataSourceWithUsedSegments(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getUsedSegmentsInDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") @Nullable String full) {
        ImmutableDruidDataSource dataSource = this.segmentsMetadataManager.getImmutableDataSourceWithUsedSegments(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Collections2.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getUsedSegmentsInDataSourceForIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") @Nullable String full, List<Interval> intervals) {
        Collection<DataSegment> segments = this.metadataStorageCoordinator.retrieveUsedSegmentsForIntervals(dataSourceName, intervals, Segments.INCLUDING_OVERSHADOWED);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(segments).build();
        }
        return builder.entity((Object)Collections2.transform(segments, DataSegment::getId)).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response isSegmentUsed(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.segmentsMetadataManager.getImmutableDataSourceWithUsedSegments(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (SegmentId possibleSegmentId : SegmentId.iteratePossibleParsingsWithDataSource((String)dataSourceName, (String)segmentId)) {
            DataSegment segment = dataSource.getSegment(possibleSegmentId);
            if (segment == null) continue;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

