/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public abstract class LoadRule
implements Rule {
    private static final EmittingLogger log = new EmittingLogger(LoadRule.class);
    static final String ASSIGNED_COUNT = "assignedCount";
    static final String DROPPED_COUNT = "droppedCount";
    public final String NON_PRIMARY_ASSIGNED_COUNT = "totalNonPrimaryReplicantsLoaded";
    public static final String REQUIRED_CAPACITY = "requiredCapacity";
    private final Object2IntMap<String> targetReplicants = new Object2IntOpenHashMap();
    private final Object2IntMap<String> currentReplicants = new Object2IntOpenHashMap();
    private final Map<String, ServerHolder> strategyCache = new HashMap<String, ServerHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinatorStats run(DruidCoordinator coordinator, DruidCoordinatorRuntimeParams params, DataSegment segment) {
        try {
            this.targetReplicants.putAll(this.getTieredReplicants());
            this.currentReplicants.putAll(params.getSegmentReplicantLookup().getClusterTiers(segment.getId()));
            CoordinatorStats stats = new CoordinatorStats();
            this.assign(params, segment, stats);
            this.drop(params, segment, stats);
            for (String tier : this.targetReplicants.keySet()) {
                stats.addToTieredStat(REQUIRED_CAPACITY, tier, segment.getSize() * (long)this.targetReplicants.getInt((Object)tier));
            }
            Object object = stats;
            return object;
        }
        finally {
            this.targetReplicants.clear();
            this.currentReplicants.clear();
            this.strategyCache.clear();
        }
    }

    @Override
    public boolean canLoadSegments() {
        return true;
    }

    @Override
    public void updateUnderReplicated(Map<String, Object2LongMap<String>> underReplicatedPerTier, SegmentReplicantLookup segmentReplicantLookup, DataSegment segment) {
        this.getTieredReplicants().forEach((tier, ruleReplicants) -> {
            int currentReplicants = segmentReplicantLookup.getLoadedReplicants(segment.getId(), (String)tier);
            Object2LongMap underReplicationPerDataSource = underReplicatedPerTier.computeIfAbsent((String)tier, ignored -> new Object2LongOpenHashMap());
            ((Object2LongOpenHashMap)underReplicationPerDataSource).addTo((Object)segment.getDataSource(), (long)Math.max(ruleReplicants - currentReplicants, 0));
        });
    }

    @Override
    public void updateUnderReplicatedWithClusterView(Map<String, Object2LongMap<String>> underReplicatedPerTier, SegmentReplicantLookup segmentReplicantLookup, DruidCluster cluster, DataSegment segment) {
        this.getTieredReplicants().forEach((tier, ruleReplicants) -> {
            int currentReplicants = segmentReplicantLookup.getLoadedReplicants(segment.getId(), (String)tier);
            Object2LongMap underReplicationPerDataSource = underReplicatedPerTier.computeIfAbsent((String)tier, ignored -> new Object2LongOpenHashMap());
            int possibleReplicants = Math.min(ruleReplicants, cluster.getHistoricals().get(tier).size());
            log.debug("ruleReplicants: [%d], possibleReplicants: [%d], currentReplicants: [%d]", new Object[]{ruleReplicants, possibleReplicants, currentReplicants});
            ((Object2LongOpenHashMap)underReplicationPerDataSource).addTo((Object)segment.getDataSource(), (long)Math.max(possibleReplicants - currentReplicants, 0));
        });
    }

    private void assign(DruidCoordinatorRuntimeParams params, DataSegment segment, CoordinatorStats stats) {
        int loading = params.getSegmentReplicantLookup().getTotalReplicants(segment.getId());
        if (!this.currentReplicants.isEmpty() || loading > 0) {
            this.assignReplicas(params, segment, stats, null);
        } else {
            ServerHolder primaryHolderToLoad = this.assignPrimary(params, segment);
            if (primaryHolderToLoad == null) {
                return;
            }
            int numAssigned = 1;
            String tier = primaryHolderToLoad.getServer().getTier();
            numAssigned += this.assignReplicasForTier(tier, this.targetReplicants.getOrDefault((Object)tier, 0), numAssigned, params, LoadRule.createLoadQueueSizeLimitingPredicate(segment).and(holder -> !holder.equals(primaryHolderToLoad)), segment);
            stats.addToGlobalStat("totalNonPrimaryReplicantsLoaded", numAssigned - 1);
            stats.addToTieredStat(ASSIGNED_COUNT, tier, numAssigned);
            this.assignReplicas(params, segment, stats, tier);
        }
    }

    private static Predicate<ServerHolder> createLoadQueueSizeLimitingPredicate(DataSegment segment) {
        return server -> server != null && server.canLoadSegment(segment);
    }

    private static List<ServerHolder> getFilteredHolders(String tier, DruidCluster druidCluster, Predicate<ServerHolder> predicate) {
        NavigableSet<ServerHolder> queue = druidCluster.getHistoricalsByTier(tier);
        if (queue == null) {
            log.makeAlert("Tier[%s] has no servers! Check your cluster configuration!", new Object[]{tier}).emit();
            return Collections.emptyList();
        }
        Predicate<ServerHolder> isActive = s -> !s.isDecommissioning();
        return queue.stream().filter(isActive.and(predicate)).collect(Collectors.toList());
    }

    private Iterator<ServerHolder> getRoundRobinIterator(DruidCoordinatorRuntimeParams params, String tier, DataSegment segment) {
        if (params.getRoundRobinServerSelector() == null || !params.getCoordinatorDynamicConfig().isUseRoundRobinSegmentAssignment()) {
            return null;
        }
        return params.getRoundRobinServerSelector().getServersInTierToLoadSegment(tier, segment);
    }

    @Nullable
    private ServerHolder assignPrimary(DruidCoordinatorRuntimeParams params, DataSegment segment) {
        ServerHolder topCandidate = null;
        boolean useRoundRobinAssignment = params.getCoordinatorDynamicConfig().isUseRoundRobinSegmentAssignment();
        for (Object2IntMap.Entry entry : this.targetReplicants.object2IntEntrySet()) {
            ServerHolder candidate;
            int targetReplicantsInTier = entry.getIntValue();
            if (targetReplicantsInTier <= 0) continue;
            String tier = (String)entry.getKey();
            String noAvailability = StringUtils.format((String)"No available [%s] servers or node capacity to assign primary segment [%s]! %s", (Object[])new Object[]{tier, segment.getId(), this.getReplicationLogString()});
            List<ServerHolder> holders = LoadRule.getFilteredHolders(tier, params.getDruidCluster(), LoadRule.createLoadQueueSizeLimitingPredicate(segment));
            if (holders.isEmpty()) {
                log.warn(noAvailability, new Object[0]);
                continue;
            }
            if (useRoundRobinAssignment) {
                Iterator<ServerHolder> roundRobinIterator = this.getRoundRobinIterator(params, tier, segment);
                candidate = roundRobinIterator.hasNext() ? roundRobinIterator.next() : null;
            } else {
                candidate = params.getBalancerStrategy().findNewSegmentHomeReplicator(segment, holders);
                if (candidate != null) {
                    this.strategyCache.put(tier, candidate);
                }
            }
            if (candidate == null) {
                log.warn(noAvailability, new Object[0]);
                continue;
            }
            if (topCandidate != null && candidate.getServer().getPriority() <= topCandidate.getServer().getPriority()) continue;
            topCandidate = candidate;
        }
        if (topCandidate != null) {
            this.strategyCache.remove(topCandidate.getServer().getTier());
            log.info("Assigning 'primary' for segment [%s] to server [%s] in tier [%s]", new Object[]{segment.getId(), topCandidate.getServer().getName(), topCandidate.getServer().getTier()});
            topCandidate.getPeon().loadSegment(segment, null);
        }
        return topCandidate;
    }

    private void assignReplicas(DruidCoordinatorRuntimeParams params, DataSegment segment, CoordinatorStats stats, @Nullable String tierToSkip) {
        for (Object2IntMap.Entry entry : this.targetReplicants.object2IntEntrySet()) {
            String tier = (String)entry.getKey();
            if (tier.equals(tierToSkip)) {
                log.info("Skipping replica assignment for segment [%s] to tier [%s]", new Object[]{segment.getId(), tier});
                continue;
            }
            int numAssigned = this.assignReplicasForTier(tier, entry.getIntValue(), params.getSegmentReplicantLookup().getTotalReplicants(segment.getId(), tier), params, LoadRule.createLoadQueueSizeLimitingPredicate(segment), segment);
            stats.addToGlobalStat("totalNonPrimaryReplicantsLoaded", numAssigned);
            stats.addToTieredStat(ASSIGNED_COUNT, tier, numAssigned);
        }
    }

    private int assignReplicasForTier(String tier, int targetReplicantsInTier, int currentReplicantsInTier, DruidCoordinatorRuntimeParams params, Predicate<ServerHolder> predicate, DataSegment segment) {
        int numToAssign = targetReplicantsInTier - currentReplicantsInTier;
        if (numToAssign <= 0) {
            return 0;
        }
        String noAvailability = StringUtils.format((String)"No available [%s] servers or node capacity to assign segment [%s]! %s", (Object[])new Object[]{tier, segment.getId(), this.getReplicationLogString()});
        List<ServerHolder> holders = LoadRule.getFilteredHolders(tier, params.getDruidCluster(), predicate);
        if (holders.isEmpty()) {
            log.warn(noAvailability, new Object[0]);
            return 0;
        }
        Iterator<ServerHolder> roundRobinServerIterator = this.getRoundRobinIterator(params, tier, segment);
        ReplicationThrottler throttler = params.getReplicationManager();
        for (int numAssigned = 0; numAssigned < numToAssign; ++numAssigned) {
            ServerHolder holder;
            if (!throttler.canCreateReplicant(tier)) {
                log.info("Throttling replication for segment [%s] in tier [%s]. %s", new Object[]{segment.getId(), tier, this.getReplicationLogString()});
                return numAssigned;
            }
            if (this.strategyCache.containsKey(tier)) {
                holder = this.strategyCache.remove(tier);
            } else if (roundRobinServerIterator == null) {
                holder = params.getBalancerStrategy().findNewSegmentHomeReplicator(segment, holders);
            } else {
                ServerHolder serverHolder = holder = roundRobinServerIterator.hasNext() ? roundRobinServerIterator.next() : null;
            }
            if (holder == null) {
                log.warn(noAvailability, new Object[0]);
                return numAssigned;
            }
            holders.remove(holder);
            SegmentId segmentId = segment.getId();
            String holderHost = holder.getServer().getHost();
            throttler.registerReplicantCreation(tier, segmentId, holderHost);
            log.info("Assigning 'replica' for segment [%s] to server [%s] in tier [%s]. %s", new Object[]{segment.getId(), holder.getServer().getName(), holder.getServer().getTier(), this.getReplicationLogString()});
            holder.getPeon().loadSegment(segment, loadSuccess -> throttler.unregisterReplicantCreation(tier, segmentId));
        }
        return numToAssign;
    }

    private void drop(DruidCoordinatorRuntimeParams params, DataSegment segment, CoordinatorStats stats) {
        DruidCluster druidCluster = params.getDruidCluster();
        boolean isLoading = this.loadingInProgress(druidCluster);
        for (Object2IntMap.Entry entry : this.currentReplicants.object2IntEntrySet()) {
            int numDropped;
            String tier = (String)entry.getKey();
            NavigableSet<ServerHolder> holders = druidCluster.getHistoricalsByTier(tier);
            if (holders == null) {
                log.makeAlert("No holders found for tier[%s]", new Object[]{tier}).emit();
                numDropped = 0;
            } else {
                int currentReplicantsInTier = entry.getIntValue();
                int numToDrop = currentReplicantsInTier - this.targetReplicants.getOrDefault((Object)tier, 0);
                if (numToDrop > 0) {
                    if (isLoading) {
                        log.info("Loading in progress for segment [%s], skipping drop from tier [%s] until loading is complete! %s", new Object[]{segment.getId(), tier, this.getReplicationLogString()});
                        break;
                    }
                    numDropped = LoadRule.dropForTier(numToDrop, holders, segment, params.getBalancerStrategy(), this.getReplicationLogString());
                } else {
                    numDropped = 0;
                }
            }
            stats.addToTieredStat(DROPPED_COUNT, tier, numDropped);
        }
    }

    private boolean loadingInProgress(DruidCluster druidCluster) {
        for (Object2IntMap.Entry entry : this.targetReplicants.object2IntEntrySet()) {
            String tier = (String)entry.getKey();
            if (!druidCluster.hasTier(tier) || entry.getIntValue() <= this.currentReplicants.getOrDefault((Object)tier, 0)) continue;
            return true;
        }
        return false;
    }

    private static int dropForTier(int numToDrop, NavigableSet<ServerHolder> holdersInTier, DataSegment segment, BalancerStrategy balancerStrategy, String replicationLog) {
        Map<Boolean, TreeSet> holders = holdersInTier.stream().filter(s -> s.isServingSegment(segment)).collect(Collectors.partitioningBy(ServerHolder::isDecommissioning, Collectors.toCollection(TreeSet::new)));
        TreeSet decommissioningServers = holders.get(true);
        TreeSet activeServers = holders.get(false);
        int left = LoadRule.dropSegmentFromServers(balancerStrategy, segment, decommissioningServers, numToDrop, replicationLog);
        if (left > 0) {
            left = LoadRule.dropSegmentFromServers(balancerStrategy, segment, activeServers, left, replicationLog);
        }
        if (left != 0) {
            log.warn("I have no servers serving [%s]?", new Object[]{segment.getId()});
        }
        return numToDrop - left;
    }

    private static int dropSegmentFromServers(BalancerStrategy balancerStrategy, DataSegment segment, NavigableSet<ServerHolder> holders, int numToDrop, String replicationLog) {
        Iterator<ServerHolder> iterator = balancerStrategy.pickServersToDrop(segment, holders);
        while (numToDrop > 0 && iterator.hasNext()) {
            ServerHolder holder = iterator.next();
            if (holder.isServingSegment(segment)) {
                log.info("Dropping segment [%s] on server [%s] in tier [%s]. %s", new Object[]{segment.getId(), holder.getServer().getName(), holder.getServer().getTier(), replicationLog});
                holder.getPeon().dropSegment(segment, null);
                --numToDrop;
                continue;
            }
            log.warn("Server [%s] is no longer serving segment [%s], skipping drop.", new Object[]{holder.getServer().getName(), segment.getId()});
        }
        return numToDrop;
    }

    protected static void validateTieredReplicants(Map<String, Integer> tieredReplicants) {
        if (tieredReplicants.size() == 0) {
            throw new IAE("A rule with empty tiered replicants is invalid", new Object[0]);
        }
        for (Map.Entry<String, Integer> entry : tieredReplicants.entrySet()) {
            if (entry.getValue() == null) {
                throw new IAE("Replicant value cannot be empty", new Object[0]);
            }
            if (entry.getValue() >= 0) continue;
            throw new IAE("Replicant value [%d] is less than 0, which is not allowed", new Object[]{entry.getValue()});
        }
    }

    public abstract Map<String, Integer> getTieredReplicants();

    public abstract int getNumReplicants(String var1);

    protected String getReplicationLogString() {
        StringBuilder builder = new StringBuilder("Current replication: [");
        for (Object2IntMap.Entry entry : this.currentReplicants.object2IntEntrySet()) {
            String tier = (String)entry.getKey();
            builder.append("[").append(tier).append(":").append(entry.getIntValue()).append("/").append(this.targetReplicants.getInt((Object)tier)).append("]");
        }
        return builder.append("]").toString();
    }
}

