/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class ForeverLoadRule
extends LoadRule {
    private final Map<String, Integer> tieredReplicants;

    @JsonCreator
    public ForeverLoadRule(@JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants) {
        this.tieredReplicants = tieredReplicants == null ? ImmutableMap.of((Object)"_default_tier", (Object)2) : tieredReplicants;
        ForeverLoadRule.validateTieredReplicants(this.tieredReplicants);
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadForever";
    }

    @Override
    @JsonProperty
    public Map<String, Integer> getTieredReplicants() {
        return this.tieredReplicants;
    }

    @Override
    public int getNumReplicants(String tier) {
        Integer retVal = this.tieredReplicants.get(tier);
        return retVal == null ? 0 : retVal;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return true;
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeverLoadRule that = (ForeverLoadRule)o;
        return Objects.equals(this.tieredReplicants, that.tieredReplicants);
    }

    public int hashCode() {
        return Objects.hash(this.tieredReplicants);
    }
}

