/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class MarkAsUnusedOvershadowedSegments
implements CoordinatorDuty {
    private static final Logger log = new Logger(MarkAsUnusedOvershadowedSegments.class);
    private final DruidCoordinator coordinator;

    public MarkAsUnusedOvershadowedSegments(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (!params.coordinatorIsLeadingEnoughTimeToMarkAsUnusedOvershadowedSegements()) {
            log.info("Skipping MarkAsUnused as coordinator is not leading enough time.", new Object[0]);
            return params;
        }
        ImmutableSet<DataSegment> allOvershadowedSegments = params.getDataSourcesSnapshot().getOvershadowedSegments();
        if (allOvershadowedSegments.isEmpty()) {
            log.info("Skipping MarkAsUnused as there are no overshadowed segments.", new Object[0]);
            return params;
        }
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        HashMap<String, SegmentTimeline> timelines = new HashMap<String, SegmentTimeline>();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                this.addSegmentsFromServer(serverHolder, timelines);
            }
        }
        for (ServerHolder serverHolder : cluster.getBrokers()) {
            this.addSegmentsFromServer(serverHolder, timelines);
        }
        HashMap<String, Set> datasourceToUnusedSegments = new HashMap<String, Set>();
        for (DataSegment dataSegment : allOvershadowedSegments) {
            SegmentTimeline timeline = (SegmentTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null || !timeline.isOvershadowed(dataSegment)) continue;
            datasourceToUnusedSegments.computeIfAbsent(dataSegment.getDataSource(), ds -> new HashSet()).add(dataSegment.getId());
            stats.addToGlobalStat("overShadowedCount", 1L);
        }
        datasourceToUnusedSegments.forEach(this.coordinator::markSegmentsAsUnused);
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }

    private void addSegmentsFromServer(ServerHolder serverHolder, Map<String, SegmentTimeline> timelines) {
        ImmutableDruidServer server = serverHolder.getServer();
        for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
            SegmentTimeline timeline = timelines.computeIfAbsent(dataSource.getName(), dsName -> new SegmentTimeline());
            VersionedIntervalTimeline.addSegments((VersionedIntervalTimeline)timeline, dataSource.getSegments().iterator());
        }
    }
}

