/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.joda.time.Duration;

public class KillSupervisorsCustomDuty
implements CoordinatorCustomDuty {
    private static final Logger log = new Logger(KillSupervisorsCustomDuty.class);
    private final Duration retainDuration;
    private final MetadataSupervisorManager metadataSupervisorManager;

    @JsonCreator
    public KillSupervisorsCustomDuty(@JsonProperty(value="retainDuration") Duration retainDuration, @JacksonInject MetadataSupervisorManager metadataSupervisorManager) {
        this.metadataSupervisorManager = metadataSupervisorManager;
        this.retainDuration = retainDuration;
        Preconditions.checkArgument((this.retainDuration != null && this.retainDuration.getMillis() >= 0L ? 1 : 0) != 0, (Object)"(Custom Duty) Coordinator supervisor kill retainDuration must be >= 0");
        log.info("Supervisor Kill Task scheduling enabled with retainDuration [%s]", new Object[]{this.retainDuration});
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        long timestamp = System.currentTimeMillis() - this.retainDuration.getMillis();
        try {
            int supervisorRemoved = this.metadataSupervisorManager.removeTerminatedSupervisorsOlderThan(timestamp);
            ServiceEmitter emitter = params.getEmitter();
            emitter.emit(new ServiceMetricEvent.Builder().build("metadata/kill/supervisor/count", (Number)supervisorRemoved));
            log.info("Finished running KillSupervisors duty. Removed %,d supervisor specs", new Object[]{supervisorRemoved});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to kill terminated supervisor metadata", new Object[0]);
        }
        return params;
    }
}

