/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;

public class KillAuditLog
implements CoordinatorDuty {
    private static final Logger log = new Logger(KillAuditLog.class);
    private final long period;
    private final long retainDuration;
    private long lastKillTime = 0L;
    private final AuditManager auditManager;

    @Inject
    public KillAuditLog(AuditManager auditManager, DruidCoordinatorConfig config) {
        this.period = config.getCoordinatorAuditKillPeriod().getMillis();
        Preconditions.checkArgument((this.period >= config.getCoordinatorMetadataStoreManagementPeriod().getMillis() ? 1 : 0) != 0, (Object)"coordinator audit kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.retainDuration = config.getCoordinatorAuditKillDurationToRetain().getMillis();
        Preconditions.checkArgument((this.retainDuration >= 0L ? 1 : 0) != 0, (Object)"coordinator audit kill retainDuration must be >= 0");
        Preconditions.checkArgument((this.retainDuration < System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Coordinator audit kill retainDuration cannot be greater than current time in ms");
        log.debug("Audit Kill Task scheduling enabled with period [%s], retainDuration [%s]", new Object[]{this.period, this.retainDuration});
        this.auditManager = auditManager;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastKillTime + this.period < currentTimeMillis) {
            this.lastKillTime = currentTimeMillis;
            long timestamp = currentTimeMillis - this.retainDuration;
            try {
                int auditRemoved = this.auditManager.removeAuditLogsOlderThan(timestamp);
                ServiceEmitter emitter = params.getEmitter();
                emitter.emit(new ServiceMetricEvent.Builder().build("metadata/kill/audit/count", (Number)auditRemoved));
                log.info("Finished running KillAuditLog duty. Removed %,d audit logs", new Object[]{auditRemoved});
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to kill audit log", new Object[0]);
            }
        }
        return params;
    }
}

