/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.utils.CollectionUtils;

public class DruidCluster {
    private final Set<ServerHolder> realtimes;
    private final Map<String, NavigableSet<ServerHolder>> historicals;
    private final Set<ServerHolder> brokers;

    @VisibleForTesting
    static DruidCluster createDruidClusterFromBuilderInTest(@Nullable Set<ServerHolder> realtimes, Map<String, Iterable<ServerHolder>> historicals, @Nullable Set<ServerHolder> brokers) {
        return new DruidCluster(realtimes, historicals, brokers);
    }

    public DruidCluster() {
        this.realtimes = new HashSet<ServerHolder>();
        this.historicals = new HashMap<String, NavigableSet<ServerHolder>>();
        this.brokers = new HashSet<ServerHolder>();
    }

    private DruidCluster(@Nullable Set<ServerHolder> realtimes, Map<String, Iterable<ServerHolder>> historicals, @Nullable Set<ServerHolder> brokers) {
        this.realtimes = realtimes == null ? new HashSet<ServerHolder>() : new HashSet<ServerHolder>(realtimes);
        this.historicals = CollectionUtils.mapValues(historicals, holders -> CollectionUtils.newTreeSet(Comparator.reverseOrder(), (Iterable)holders));
        this.brokers = brokers == null ? new HashSet<ServerHolder>() : new HashSet<ServerHolder>(brokers);
    }

    public void add(ServerHolder serverHolder) {
        switch (serverHolder.getServer().getType()) {
            case HISTORICAL: {
                this.addHistorical(serverHolder);
                break;
            }
            case REALTIME: {
                this.addRealtime(serverHolder);
                break;
            }
            case BRIDGE: {
                this.addHistorical(serverHolder);
                break;
            }
            case INDEXER_EXECUTOR: {
                this.addRealtime(serverHolder);
                break;
            }
            case BROKER: {
                this.addBroker(serverHolder);
                break;
            }
            default: {
                throw new IAE("unknown server type[%s]", new Object[]{serverHolder.getServer().getType()});
            }
        }
    }

    private void addRealtime(ServerHolder serverHolder) {
        this.realtimes.add(serverHolder);
    }

    private void addHistorical(ServerHolder serverHolder) {
        ImmutableDruidServer server = serverHolder.getServer();
        NavigableSet tierServers = this.historicals.computeIfAbsent(server.getTier(), k -> new TreeSet(Collections.reverseOrder()));
        tierServers.add(serverHolder);
    }

    private void addBroker(ServerHolder serverHolder) {
        this.brokers.add(serverHolder);
    }

    public Set<ServerHolder> getRealtimes() {
        return this.realtimes;
    }

    public Map<String, NavigableSet<ServerHolder>> getHistoricals() {
        return this.historicals;
    }

    public Set<ServerHolder> getBrokers() {
        return this.brokers;
    }

    public Iterable<String> getTierNames() {
        return this.historicals.keySet();
    }

    public NavigableSet<ServerHolder> getHistoricalsByTier(String tier) {
        return this.historicals.get(tier);
    }

    public Collection<ServerHolder> getAllServers() {
        int historicalSize = this.historicals.values().stream().mapToInt(Collection::size).sum();
        int realtimeSize = this.realtimes.size();
        ArrayList<ServerHolder> allServers = new ArrayList<ServerHolder>(historicalSize + realtimeSize);
        this.historicals.values().forEach(allServers::addAll);
        allServers.addAll(this.brokers);
        allServers.addAll(this.realtimes);
        return allServers;
    }

    public Iterable<NavigableSet<ServerHolder>> getSortedHistoricalsByTier() {
        return this.historicals.values();
    }

    public boolean isEmpty() {
        return this.historicals.isEmpty() && this.realtimes.isEmpty() && this.brokers.isEmpty();
    }

    public boolean hasHistoricals() {
        return !this.historicals.isEmpty();
    }

    public boolean hasRealtimes() {
        return !this.realtimes.isEmpty();
    }

    public boolean hasBrokers() {
        return !this.brokers.isEmpty();
    }

    public boolean hasTier(String tier) {
        boolean historicalsHasTier;
        NavigableSet<ServerHolder> historicalServers = this.historicals.get(tier);
        boolean bl = historicalsHasTier = historicalServers != null && !historicalServers.isEmpty();
        return historicalsHasTier;
    }
}

