/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.druid.java.util.common.ISE;

public class AutoCompactionSnapshot {
    @JsonProperty
    private String dataSource;
    @JsonProperty
    private AutoCompactionScheduleStatus scheduleStatus;
    @JsonProperty
    private long bytesAwaitingCompaction;
    @JsonProperty
    private long bytesCompacted;
    @JsonProperty
    private long bytesSkipped;
    @JsonProperty
    private long segmentCountAwaitingCompaction;
    @JsonProperty
    private long segmentCountCompacted;
    @JsonProperty
    private long segmentCountSkipped;
    @JsonProperty
    private long intervalCountAwaitingCompaction;
    @JsonProperty
    private long intervalCountCompacted;
    @JsonProperty
    private long intervalCountSkipped;

    @JsonCreator
    public AutoCompactionSnapshot(@JsonProperty @NotNull String dataSource, @JsonProperty @NotNull AutoCompactionScheduleStatus scheduleStatus, @JsonProperty long bytesAwaitingCompaction, @JsonProperty long bytesCompacted, @JsonProperty long bytesSkipped, @JsonProperty long segmentCountAwaitingCompaction, @JsonProperty long segmentCountCompacted, @JsonProperty long segmentCountSkipped, @JsonProperty long intervalCountAwaitingCompaction, @JsonProperty long intervalCountCompacted, @JsonProperty long intervalCountSkipped) {
        this.dataSource = dataSource;
        this.scheduleStatus = scheduleStatus;
        this.bytesAwaitingCompaction = bytesAwaitingCompaction;
        this.bytesCompacted = bytesCompacted;
        this.bytesSkipped = bytesSkipped;
        this.segmentCountAwaitingCompaction = segmentCountAwaitingCompaction;
        this.segmentCountCompacted = segmentCountCompacted;
        this.segmentCountSkipped = segmentCountSkipped;
        this.intervalCountAwaitingCompaction = intervalCountAwaitingCompaction;
        this.intervalCountCompacted = intervalCountCompacted;
        this.intervalCountSkipped = intervalCountSkipped;
    }

    @NotNull
    public String getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public AutoCompactionScheduleStatus getScheduleStatus() {
        return this.scheduleStatus;
    }

    public long getBytesAwaitingCompaction() {
        return this.bytesAwaitingCompaction;
    }

    public long getBytesCompacted() {
        return this.bytesCompacted;
    }

    public long getBytesSkipped() {
        return this.bytesSkipped;
    }

    public long getSegmentCountAwaitingCompaction() {
        return this.segmentCountAwaitingCompaction;
    }

    public long getSegmentCountCompacted() {
        return this.segmentCountCompacted;
    }

    public long getSegmentCountSkipped() {
        return this.segmentCountSkipped;
    }

    public long getIntervalCountAwaitingCompaction() {
        return this.intervalCountAwaitingCompaction;
    }

    public long getIntervalCountCompacted() {
        return this.intervalCountCompacted;
    }

    public long getIntervalCountSkipped() {
        return this.intervalCountSkipped;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoCompactionSnapshot that = (AutoCompactionSnapshot)o;
        return this.bytesAwaitingCompaction == that.bytesAwaitingCompaction && this.bytesCompacted == that.bytesCompacted && this.bytesSkipped == that.bytesSkipped && this.segmentCountAwaitingCompaction == that.segmentCountAwaitingCompaction && this.segmentCountCompacted == that.segmentCountCompacted && this.segmentCountSkipped == that.segmentCountSkipped && this.intervalCountAwaitingCompaction == that.intervalCountAwaitingCompaction && this.intervalCountCompacted == that.intervalCountCompacted && this.intervalCountSkipped == that.intervalCountSkipped && this.dataSource.equals(that.dataSource) && this.scheduleStatus == that.scheduleStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSource, this.scheduleStatus, this.bytesAwaitingCompaction, this.bytesCompacted, this.bytesSkipped, this.segmentCountAwaitingCompaction, this.segmentCountCompacted, this.segmentCountSkipped, this.intervalCountAwaitingCompaction, this.intervalCountCompacted, this.intervalCountSkipped});
    }

    public static class Builder {
        private String dataSource;
        private AutoCompactionScheduleStatus scheduleStatus;
        private long bytesAwaitingCompaction;
        private long bytesCompacted;
        private long bytesSkipped;
        private long segmentCountAwaitingCompaction;
        private long segmentCountCompacted;
        private long segmentCountSkipped;
        private long intervalCountAwaitingCompaction;
        private long intervalCountCompacted;
        private long intervalCountSkipped;

        public Builder(@NotNull String dataSource, @NotNull AutoCompactionScheduleStatus scheduleStatus) {
            this.dataSource = dataSource;
            this.scheduleStatus = scheduleStatus;
            this.bytesAwaitingCompaction = 0L;
            this.bytesCompacted = 0L;
            this.bytesSkipped = 0L;
            this.segmentCountAwaitingCompaction = 0L;
            this.segmentCountCompacted = 0L;
            this.segmentCountSkipped = 0L;
            this.intervalCountAwaitingCompaction = 0L;
            this.intervalCountCompacted = 0L;
            this.intervalCountSkipped = 0L;
        }

        public Builder incrementBytesAwaitingCompaction(long incrementValue) {
            this.bytesAwaitingCompaction += incrementValue;
            return this;
        }

        public Builder incrementBytesCompacted(long incrementValue) {
            this.bytesCompacted += incrementValue;
            return this;
        }

        public Builder incrementSegmentCountAwaitingCompaction(long incrementValue) {
            this.segmentCountAwaitingCompaction += incrementValue;
            return this;
        }

        public Builder incrementSegmentCountCompacted(long incrementValue) {
            this.segmentCountCompacted += incrementValue;
            return this;
        }

        public Builder incrementIntervalCountAwaitingCompaction(long incrementValue) {
            this.intervalCountAwaitingCompaction += incrementValue;
            return this;
        }

        public Builder incrementIntervalCountCompacted(long incrementValue) {
            this.intervalCountCompacted += incrementValue;
            return this;
        }

        public Builder incrementBytesSkipped(long incrementValue) {
            this.bytesSkipped += incrementValue;
            return this;
        }

        public Builder incrementSegmentCountSkipped(long incrementValue) {
            this.segmentCountSkipped += incrementValue;
            return this;
        }

        public Builder incrementIntervalCountSkipped(long incrementValue) {
            this.intervalCountSkipped += incrementValue;
            return this;
        }

        public AutoCompactionSnapshot build() {
            if (this.dataSource == null || this.dataSource.isEmpty()) {
                throw new ISE("Invalid dataSource name", new Object[0]);
            }
            if (this.scheduleStatus == null) {
                throw new ISE("scheduleStatus cannot be null", new Object[0]);
            }
            return new AutoCompactionSnapshot(this.dataSource, this.scheduleStatus, this.bytesAwaitingCompaction, this.bytesCompacted, this.bytesSkipped, this.segmentCountAwaitingCompaction, this.segmentCountCompacted, this.segmentCountSkipped, this.intervalCountAwaitingCompaction, this.intervalCountCompacted, this.intervalCountSkipped);
        }
    }

    public static enum AutoCompactionScheduleStatus {
        NOT_ENABLED,
        RUNNING;

    }
}

