/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;

public class SqlFirehose
implements Firehose {
    private final Iterator<JsonIterator<Map<String, Object>>> resultIterator;
    private final MapInputRowParser parser;
    private final Closeable closer;
    @Nullable
    private JsonIterator<Map<String, Object>> lineIterator = null;
    private final Transformer transformer;

    public SqlFirehose(Iterator<JsonIterator<Map<String, Object>>> lineIterators, InputRowParser<?> parser, Closeable closer) {
        this.resultIterator = lineIterators;
        this.parser = new MapInputRowParser(parser.getParseSpec());
        this.transformer = TransformSpec.fromInputRowParser(parser).toTransformer();
        this.closer = closer;
    }

    public boolean hasMore() {
        while ((this.lineIterator == null || !this.lineIterator.hasNext()) && this.resultIterator.hasNext()) {
            this.lineIterator = this.getNextLineIterator();
        }
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Nullable
    public InputRow nextRow() {
        assert (this.lineIterator != null);
        Map mapToParse = (Map)this.lineIterator.next();
        return this.transformer.transform((InputRow)Iterators.getOnlyElement(this.parser.parseBatch(mapToParse).iterator()));
    }

    private JsonIterator<Map<String, Object>> getNextLineIterator() {
        if (this.lineIterator != null) {
            this.lineIterator = null;
        }
        return this.resultIterator.next();
    }

    public void close() throws IOException {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
        this.closer.close();
    }
}

