/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.prefetch.CacheManager;
import org.apache.druid.data.input.impl.prefetch.FetchConfig;
import org.apache.druid.data.input.impl.prefetch.Fetcher;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.data.input.impl.prefetch.OpenObject;

public class SqlFetcher<T>
extends Fetcher<T> {
    private static final String FETCH_FILE_PREFIX = "sqlfetch-";
    @Nullable
    private final File temporaryDirectory;
    private final ObjectOpenFunction<T> openObjectFunction;

    SqlFetcher(CacheManager<T> cacheManager, List<T> objects, ExecutorService fetchExecutor, @Nullable File temporaryDirectory, FetchConfig fetchConfig, ObjectOpenFunction<T> openObjectFunction) {
        super(cacheManager, objects, fetchExecutor, temporaryDirectory, fetchConfig);
        this.temporaryDirectory = temporaryDirectory;
        this.openObjectFunction = openObjectFunction;
    }

    protected long download(T object, File outFile) throws IOException {
        this.openObjectFunction.open(object, outFile);
        return outFile.length();
    }

    protected OpenObject<T> generateOpenObject(T object) throws IOException {
        File outFile = File.createTempFile(FETCH_FILE_PREFIX, null, this.temporaryDirectory);
        return new OpenObject(object, this.openObjectFunction.open(object, outFile), outFile::delete);
    }
}

