/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.Transformer;

public class IngestSegmentFirehose
implements Firehose {
    private final Transformer transformer;
    private Yielder<InputRow> rowYielder;

    public IngestSegmentFirehose(List<WindowedStorageAdapter> adapters, TransformSpec transformSpec, final List<String> dims, final List<String> metrics, final DimFilter dimFilter) {
        this.transformer = transformSpec.toTransformer();
        Sequence rows = Sequences.concat((Iterable)Iterables.transform(adapters, (Function)new Function<WindowedStorageAdapter, Sequence<InputRow>>(){

            @Nullable
            public Sequence<InputRow> apply(WindowedStorageAdapter adapter) {
                return Sequences.concat((Sequence)Sequences.map((Sequence)adapter.getAdapter().makeCursors(Filters.toFilter((DimFilter)dimFilter), adapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null), (Function)new Function<Cursor, Sequence<InputRow>>(){

                    @Nullable
                    public Sequence<InputRow> apply(final Cursor cursor) {
                        ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                        HashMap<String, DimensionSelector> dimSelectors = new HashMap<String, DimensionSelector>();
                        for (String dim : dims) {
                            DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(dim, dim));
                            if (dimSelector == null) continue;
                            dimSelectors.put(dim, dimSelector);
                        }
                        HashMap<String, ColumnValueSelector> metSelectors = new HashMap<String, ColumnValueSelector>();
                        for (String metric : metrics) {
                            ColumnValueSelector metricSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(metric);
                            metSelectors.put(metric, metricSelector);
                        }
                        return Sequences.simple((Iterable)new Iterable<InputRow>((BaseLongColumnValueSelector)timestampColumnSelector, dimSelectors, metSelectors){
                            final /* synthetic */ BaseLongColumnValueSelector val$timestampColumnSelector;
                            final /* synthetic */ Map val$dimSelectors;
                            final /* synthetic */ Map val$metSelectors;
                            {
                                this.val$timestampColumnSelector = baseLongColumnValueSelector;
                                this.val$dimSelectors = map;
                                this.val$metSelectors = map2;
                            }

                            @Override
                            public Iterator<InputRow> iterator() {
                                return new Iterator<InputRow>(){

                                    @Override
                                    public boolean hasNext() {
                                        return !cursor.isDone();
                                    }

                                    @Override
                                    public InputRow next() {
                                        DimensionSelector selector;
                                        LinkedHashMap theEvent = Maps.newLinkedHashMap();
                                        long timestamp = val$timestampColumnSelector.getLong();
                                        theEvent.put("timestamp", DateTimes.utc((long)timestamp));
                                        for (Map.Entry dimSelector : val$dimSelectors.entrySet()) {
                                            String dim = (String)dimSelector.getKey();
                                            selector = (DimensionSelector)dimSelector.getValue();
                                            IndexedInts vals = selector.getRow();
                                            int valsSize = vals.size();
                                            if (valsSize == 1) {
                                                String dimVal = selector.lookupName(vals.get(0));
                                                theEvent.put(dim, dimVal);
                                                continue;
                                            }
                                            if (valsSize <= 1) continue;
                                            ArrayList<String> dimVals = new ArrayList<String>(valsSize);
                                            for (int i = 0; i < valsSize; ++i) {
                                                dimVals.add(selector.lookupName(vals.get(i)));
                                            }
                                            theEvent.put(dim, dimVals);
                                        }
                                        for (Map.Entry metSelector : val$metSelectors.entrySet()) {
                                            String metric = (String)metSelector.getKey();
                                            selector = (BaseObjectColumnValueSelector)metSelector.getValue();
                                            Object value = selector.getObject();
                                            if (value == null) continue;
                                            theEvent.put(metric, value);
                                        }
                                        cursor.advance();
                                        return new MapBasedInputRow(timestamp, dims, (Map)theEvent);
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("Remove Not Supported");
                                    }
                                };
                            }
                        });
                    }
                }));
            }
        }));
        this.rowYielder = Yielders.each((Sequence)rows);
    }

    public boolean hasMore() {
        return !this.rowYielder.isDone();
    }

    @Nullable
    public InputRow nextRow() {
        InputRow inputRow = (InputRow)this.rowYielder.get();
        this.rowYielder = this.rowYielder.next(null);
        return this.transformer.transform(inputRow);
    }

    public void close() throws IOException {
        this.rowYielder.close();
    }
}

