/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Set;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.initialization.ExtensionInjectorBuilder;
import org.apache.druid.initialization.ServiceInjectorBuilder;

public class ServerInjectorBuilder {
    private final Injector baseInjector;
    private Set<NodeRole> nodeRoles;
    private Iterable<? extends Module> modules;

    @VisibleForTesting
    public static Injector makeServerInjector(Injector baseInjector, Set<NodeRole> nodeRoles, Iterable<? extends Module> modules) {
        return new ServerInjectorBuilder(baseInjector).nodeRoles(nodeRoles).serviceModules(modules).build();
    }

    public ServerInjectorBuilder(Injector baseInjector) {
        this.baseInjector = baseInjector;
    }

    public ServerInjectorBuilder nodeRoles(Set<NodeRole> nodeRoles) {
        this.nodeRoles = nodeRoles == null ? ImmutableSet.of() : nodeRoles;
        return this;
    }

    public ServerInjectorBuilder serviceModules(Iterable<? extends Module> modules) {
        this.modules = modules;
        return this;
    }

    public Injector build() {
        Preconditions.checkNotNull((Object)this.baseInjector);
        Preconditions.checkNotNull(this.nodeRoles);
        Module registerNodeRoleModule = ServerInjectorBuilder.registerNodeRoleModule(this.nodeRoles);
        Injector childInjector = this.baseInjector.createChildInjector(new Module[]{registerNodeRoleModule});
        CoreInjectorBuilder coreBuilder = new CoreInjectorBuilder(childInjector, this.nodeRoles).forServer();
        ServiceInjectorBuilder serviceBuilder = new ServiceInjectorBuilder(coreBuilder).addAll(Iterables.concat((Iterable)ImmutableList.of((Object)registerNodeRoleModule), this.modules));
        return new ExtensionInjectorBuilder(serviceBuilder).build();
    }

    public static Module registerNodeRoleModule(Set<NodeRole> nodeRoles) {
        return binder -> {
            Multibinder selfBinder = Multibinder.newSetBinder((Binder)binder, NodeRole.class, Self.class);
            nodeRoles.forEach(nodeRole -> selfBinder.addBinding().toInstance(nodeRole));
            MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<NodeRole>(){}, (TypeLiteral)new TypeLiteral<Set<Class<? extends DruidService>>>(){});
        };
    }
}

