/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ModulesConfig;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class DruidInjectorBuilder {
    private static final Logger log = new Logger(DruidInjectorBuilder.class);
    private final List<Module> modules = new ArrayList<Module>();
    protected final Injector baseInjector;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final Set<NodeRole> nodeRoles;
    private final ModulesConfig modulesConfig;

    public DruidInjectorBuilder(Injector baseInjector) {
        this(baseInjector, Collections.emptySet());
    }

    public DruidInjectorBuilder(Injector baseInjector, Set<NodeRole> nodeRoles) {
        this.baseInjector = baseInjector;
        this.nodeRoles = nodeRoles;
        this.modulesConfig = (ModulesConfig)baseInjector.getInstance(ModulesConfig.class);
        this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
        this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
    }

    public DruidInjectorBuilder(DruidInjectorBuilder from) {
        this.baseInjector = from.baseInjector;
        this.nodeRoles = from.nodeRoles;
        this.modulesConfig = from.modulesConfig;
        this.jsonMapper = from.jsonMapper;
        this.smileMapper = from.smileMapper;
    }

    public DruidInjectorBuilder add(Object ... input) {
        for (Object o : input) {
            this.addInput(o);
        }
        return this;
    }

    public DruidInjectorBuilder addModules(Module ... inputs) {
        for (Module o : inputs) {
            this.addInput(o);
        }
        return this;
    }

    public DruidInjectorBuilder addAll(List<? extends Object> inputs) {
        for (Object object : inputs) {
            this.addInput(object);
        }
        return this;
    }

    public DruidInjectorBuilder addInput(Object input) {
        if (input instanceof Module) {
            return this.addModule((Module)input);
        }
        if (input instanceof Class) {
            return this.addClass((Class)input);
        }
        throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
    }

    public DruidInjectorBuilder addModule(Module module) {
        if (!this.acceptModule(module.getClass())) {
            return this;
        }
        this.baseInjector.injectMembers((Object)module);
        if (module instanceof DruidModule) {
            this.registerJacksonModules((DruidModule)module);
        }
        this.modules.add(module);
        return this;
    }

    public DruidInjectorBuilder addClass(Class<?> input) {
        if (!this.acceptModule(input)) {
            return this;
        }
        if (DruidModule.class.isAssignableFrom(input)) {
            DruidModule module = (DruidModule)this.baseInjector.getInstance(input);
            this.registerJacksonModules(module);
            this.modules.add((Module)module);
        } else if (Module.class.isAssignableFrom(input)) {
            Module module = (Module)this.baseInjector.getInstance(input);
            this.modules.add(module);
        } else {
            throw new ISE("Class [%s] does not implement %s", new Object[]{input, Module.class});
        }
        return this;
    }

    private boolean acceptModule(Class<?> moduleClass) {
        String moduleClassName = moduleClass.getName();
        if (moduleClassName != null && this.modulesConfig.getExcludeList().contains(moduleClassName)) {
            log.info("Not loading module [%s] because it is present in excludeList", new Object[]{moduleClassName});
            return false;
        }
        LoadScope loadScope = moduleClass.getAnnotation(LoadScope.class);
        if (loadScope == null) {
            return true;
        }
        Set rolesPredicate = Arrays.stream(loadScope.roles()).map(NodeRole::fromJsonName).collect(Collectors.toSet());
        return rolesPredicate.stream().anyMatch(this.nodeRoles::contains);
    }

    private void registerJacksonModules(DruidModule module) {
        for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
            this.jsonMapper.registerModule(jacksonModule);
            this.smileMapper.registerModule(jacksonModule);
        }
    }

    public List<Module> modules() {
        return this.modules;
    }

    public Injector build() {
        return Guice.createInjector(this.modules);
    }
}

