/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import org.apache.druid.client.cache.BackgroundCachePopulator;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleForkJoinPoolProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ExecutorServiceConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.offheap.OffheapBufferGenerator;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.query.ForwardingQueryProcessingPool;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.utils.JvmUtils;

public class BrokerProcessingModule
implements Module {
    private static final Logger log = new Logger(BrokerProcessingModule.class);

    public void configure(Binder binder) {
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @LazySingleton
    public CachePopulator getCachePopulator(@Smile ObjectMapper smileMapper, CachePopulatorStats cachePopulatorStats, CacheConfig cacheConfig) {
        if (cacheConfig.getNumBackgroundThreads() > 0) {
            ExecutorService exec = Executors.newFixedThreadPool(cacheConfig.getNumBackgroundThreads(), new ThreadFactoryBuilder().setNameFormat("background-cacher-%d").setDaemon(true).setPriority(1).build());
            return new BackgroundCachePopulator(exec, smileMapper, cachePopulatorStats, cacheConfig.getMaxEntrySize());
        }
        return new ForegroundCachePopulator(smileMapper, cachePopulatorStats, cacheConfig.getMaxEntrySize());
    }

    @Provides
    @ManageLifecycle
    public QueryProcessingPool getProcessingExecutorPool(DruidProcessingConfig config) {
        return new ForwardingQueryProcessingPool(Execs.dummy());
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new StupidPool("intermediate processing pool", (Supplier)new OffheapBufferGenerator("intermediate processing", config.intermediateComputeSizeBytes()), config.getNumInitalBuffersForIntermediatePool(), config.poolCacheMaxCount());
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new DefaultBlockingPool((Supplier)new OffheapBufferGenerator("result merging", config.intermediateComputeSizeBytes()), config.getNumMergeBuffers());
    }

    @Provides
    @ManageLifecycle
    public LifecycleForkJoinPoolProvider getMergeProcessingPoolProvider(DruidProcessingConfig config) {
        return new LifecycleForkJoinPoolProvider(config.getMergePoolParallelism(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, (t, e) -> log.error(e, "Unhandled exception in thread [%s]", new Object[]{t}), true, config.getMergePoolAwaitShutdownMillis());
    }

    @Provides
    @Merging
    public ForkJoinPool getMergeProcessingPool(LifecycleForkJoinPoolProvider poolProvider) {
        return poolProvider.getPool();
    }

    private void verifyDirectMemory(DruidProcessingConfig config) {
        long memoryNeeded = (long)config.intermediateComputeSizeBytes() * (long)(config.getNumMergeBuffers() + 1);
        try {
            long maxDirectMemory = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            if (maxDirectMemory < memoryNeeded) {
                throw new ProvisionException(StringUtils.format((String)"Not enough direct memory.  Please adjust -XX:MaxDirectMemorySize, druid.processing.buffer.sizeBytes, or druid.processing.numMergeBuffers: maxDirectMemory[%,d], memoryNeeded[%,d] = druid.processing.buffer.sizeBytes[%,d] * (druid.processing.numMergeBuffers[%,d] + 1)", (Object[])new Object[]{maxDirectMemory, memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumMergeBuffers()}));
            }
        }
        catch (UnsupportedOperationException e) {
            log.debug("Checking for direct memory size is not support on this platform: %s", new Object[]{e});
            log.info("Your memory settings require at least %,d bytes of direct memory. Your machine must have at least this much memory available, and your JVM -XX:MaxDirectMemorySize parameter must be at least this high. If it is, you may safely ignore this message. Otherwise, consider adjusting your memory settings. Calculation: druid.processing.buffer.sizeBytes[%,d] * (druid.processing.numMergeBuffers[%,d] + 1).", new Object[]{memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumMergeBuffers()});
        }
    }
}

