/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.jackson.StringObjectPairList;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;

public class DiscoveryDruidNode {
    private static final Logger LOG = new Logger(DiscoveryDruidNode.class);
    private final DruidNode druidNode;
    private final NodeRole nodeRole;
    private final Map<String, DruidService> services = new HashMap<String, DruidService>();

    public DiscoveryDruidNode(DruidNode druidNode, NodeRole nodeRole, Map<String, DruidService> services) {
        this.druidNode = druidNode;
        this.nodeRole = nodeRole;
        if (services != null && !services.isEmpty()) {
            this.services.putAll(services);
        }
    }

    @JsonCreator
    private static DiscoveryDruidNode fromJson(@JsonProperty(value="druidNode") DruidNode druidNode, @JsonProperty(value="nodeType") NodeRole nodeRole, @JsonProperty(value="services") Map<String, StringObjectPairList> rawServices, @JacksonInject ObjectMapper jsonMapper) {
        HashMap<String, DruidService> services = new HashMap<String, DruidService>();
        if (rawServices != null && !rawServices.isEmpty()) {
            for (Map.Entry<String, StringObjectPairList> entry : rawServices.entrySet()) {
                List<NonnullPair<String, Object>> val = entry.getValue().getPairs();
                try {
                    services.put(entry.getKey(), (DruidService)jsonMapper.convertValue(DiscoveryDruidNode.toMap(val), DruidService.class));
                }
                catch (RuntimeException e) {
                    LOG.warn("Ignore unparseable DruidService for [%s]: %s", new Object[]{druidNode.getHostAndPortToUse(), val});
                }
            }
        }
        return new DiscoveryDruidNode(druidNode, nodeRole, services);
    }

    @Deprecated
    private static Map<String, Object> toMap(List<NonnullPair<String, Object>> pairs) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)pairs.size());
        for (NonnullPair<String, Object> pair : pairs) {
            Object prevVal = map.put(pair.lhs, pair.rhs);
            if (prevVal == null) continue;
            if ("type".equals(pair.lhs)) {
                if ("dataNodeService".equals(prevVal)) {
                    map.put("type", prevVal);
                    map.put("serverType", pair.rhs);
                    continue;
                }
                if ("dataNodeService".equals(pair.rhs)) {
                    map.put("serverType", prevVal);
                    continue;
                }
            } else if ("serverType".equals(pair.lhs)) continue;
            if (prevVal.equals(pair.rhs)) continue;
            throw new IAE("Duplicate key[%s] with different values: [%s] and [%s]", new Object[]{pair.lhs, prevVal, pair.rhs});
        }
        return map;
    }

    @JsonProperty
    public Map<String, DruidService> getServices() {
        return this.services;
    }

    @JsonProperty(value="nodeType")
    public NodeRole getNodeRole() {
        return this.nodeRole;
    }

    @JsonProperty
    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryDruidNode that = (DiscoveryDruidNode)o;
        return Objects.equals(this.druidNode, that.druidNode) && Objects.equals(this.nodeRole, that.nodeRole) && Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        return Objects.hash(this.druidNode, this.nodeRole, this.services);
    }

    public String toString() {
        return "DiscoveryDruidNode{druidNode=" + this.druidNode + ", nodeRole='" + this.nodeRole + '\'' + ", services=" + this.services + '}';
    }
}

