/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorClient {
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public CoordinatorClient(ObjectMapper jsonMapper, @Coordinator DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    @Nullable
    public Boolean isHandOffComplete(String dataSource, SegmentDescriptor descriptor) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/coordinator/v1/datasources/%s/handoffComplete?interval=%s&partitionNumber=%d&version=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), descriptor.getInterval(), descriptor.getPartitionNumber(), descriptor.getVersion()})));
            if (response.getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
                return null;
            }
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching serverView status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return (Boolean)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Boolean>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ImmutableSegmentLoadInfo> fetchServerView(String dataSource, Interval interval, boolean incompleteOk) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/coordinator/v1/datasources/%s/intervals/%s/serverview?partial=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), interval.toString().replace('/', '_'), incompleteOk})));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching serverView status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<ImmutableSegmentLoadInfo>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<DataSegment> fetchUsedSegmentsInDataSourceForIntervals(String dataSource, List<Interval> intervals) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, StringUtils.format((String)"/druid/coordinator/v1/metadata/datasources/%s/segments?full", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource)})).setContent("application/json", this.jsonMapper.writeValueAsBytes(intervals)));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching used segments in a data source for intervals: status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return (Collection)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<DataSegment>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataSegment fetchUsedSegment(String dataSource, String segmentId) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/coordinator/v1/metadata/datasources/%s/segments/%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), StringUtils.urlEncode((String)segmentId)})));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching database segment data source segment status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return (DataSegment)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<DataSegment>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

