/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.common.logger.Logger;

class ByteCountingLRUMap
extends LinkedHashMap<ByteBuffer, byte[]> {
    private static final Logger log = new Logger(ByteCountingLRUMap.class);
    private final boolean logEvictions;
    private final int logEvictionCount;
    private final long sizeInBytes;
    private final AtomicLong numBytes;
    private final AtomicLong evictionCount;

    public ByteCountingLRUMap(long sizeInBytes) {
        this(16, 0, sizeInBytes);
    }

    public ByteCountingLRUMap(int initialSize, int logEvictionCount, long sizeInBytes) {
        super(initialSize, 0.75f, true);
        this.logEvictionCount = logEvictionCount;
        this.sizeInBytes = sizeInBytes;
        this.logEvictions = logEvictionCount != 0;
        this.numBytes = new AtomicLong(0L);
        this.evictionCount = new AtomicLong(0L);
    }

    public long getNumBytes() {
        return this.numBytes.get();
    }

    public long getEvictionCount() {
        return this.evictionCount.get();
    }

    @Override
    public byte[] put(ByteBuffer key, byte[] value) {
        this.numBytes.addAndGet(key.remaining() + value.length);
        Iterator it = this.entrySet().iterator();
        ArrayList keysToRemove = new ArrayList();
        long totalEvictionSize = 0L;
        while (this.numBytes.get() - totalEvictionSize > this.sizeInBytes && it.hasNext()) {
            this.evictionCount.incrementAndGet();
            if (this.logEvictions && this.evictionCount.get() % (long)this.logEvictionCount == 0L) {
                log.info("Evicting %,dth element.  Size[%,d], numBytes[%,d], averageSize[%,d]", new Object[]{this.evictionCount.get(), this.size(), this.numBytes.get(), this.numBytes.get() / (long)this.size()});
            }
            Map.Entry next = it.next();
            totalEvictionSize += (long)(((ByteBuffer)next.getKey()).remaining() + ((byte[])next.getValue()).length);
            keysToRemove.add(next.getKey());
        }
        for (ByteBuffer keyToRemove : keysToRemove) {
            this.remove(keyToRemove);
        }
        byte[] old = super.put(key, value);
        if (old != null) {
            this.numBytes.addAndGet(-key.remaining() - old.length);
        }
        return old;
    }

    @Override
    public byte[] remove(Object key) {
        byte[] value = (byte[])super.remove(key);
        if (value != null) {
            long delta = -((ByteBuffer)key).remaining() - value.length;
            this.numBytes.addAndGet(delta);
        }
        return value;
    }

    @Override
    public Set<ByteBuffer> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public void clear() {
        this.numBytes.set(0L);
        super.clear();
    }
}

