/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class InputFormats {
    public static final String CSV_FORMAT_TYPE = "csv";
    public static final String DELIMITED_FORMAT_TYPE = "tsv";
    public static final String JSON_FORMAT_TYPE = "json";
    public static final InputFormatDefn CSV_FORMAT_DEFN = new CsvFormatDefn();
    public static final InputFormatDefn DELIMITED_FORMAT_DEFN = new DelimitedFormatDefn();
    public static final InputFormatDefn JSON_FORMAT_DEFN = new JsonFormatDefn();
    public static final GenericFormatDefn GENERIC_FORMAT_DEFN = new GenericFormatDefn();
    public static final List<InputFormatDefn> ALL_FORMATS = ImmutableList.of((Object)CSV_FORMAT_DEFN, (Object)DELIMITED_FORMAT_DEFN, (Object)JSON_FORMAT_DEFN, (Object)GENERIC_FORMAT_DEFN);

    public static class GenericFormatDefn
    extends BaseFormatDefn {
        public static final String INPUT_FORMAT_SPEC_PROPERTY = "inputFormatSpec";
        public static final String FORMAT_KEY = "generic";

        public GenericFormatDefn() {
            super("Generic", FORMAT_KEY, Collections.singletonList(new ModelProperties.SimplePropertyDefn<InputFormat>(INPUT_FORMAT_SPEC_PROPERTY, InputFormat.class)));
        }

        @Override
        public InputFormat convert(ResolvedTable table) {
            Object value = table.property(INPUT_FORMAT_SPEC_PROPERTY);
            if (value == null) {
                throw new ISE("An input format must be provided in the %s property when input type is %s", new Object[]{INPUT_FORMAT_SPEC_PROPERTY, this.name()});
            }
            return (InputFormat)table.jsonMapper().convertValue(value, InputFormat.class);
        }
    }

    public static class JsonFormatDefn
    extends BaseFormatDefn {
        public static final String KEEP_NULLS_PROPERTY = "keepNulls";

        public JsonFormatDefn() {
            super("JSON", InputFormats.JSON_FORMAT_TYPE, Collections.singletonList(new ModelProperties.BooleanPropertyDefn(KEEP_NULLS_PROPERTY)));
        }

        @Override
        public InputFormat convert(ResolvedTable table) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("type", InputFormats.JSON_FORMAT_TYPE);
            jsonMap.put("keepNullColumns", table.property(KEEP_NULLS_PROPERTY));
            return (InputFormat)table.jsonMapper().convertValue(jsonMap, JsonInputFormat.class);
        }
    }

    public static class DelimitedFormatDefn
    extends FlatTextFormatDefn {
        public static final String DELIMITER_PROPERTY = "delimiter";

        public DelimitedFormatDefn() {
            super("Delimited Text", InputFormats.DELIMITED_FORMAT_TYPE, Collections.singletonList(new ModelProperties.StringPropertyDefn(DELIMITER_PROPERTY)));
        }

        @Override
        protected Map<String, Object> gatherFields(ResolvedTable table) {
            Map<String, Object> jsonMap = super.gatherFields(table);
            jsonMap.put("type", InputFormats.DELIMITED_FORMAT_TYPE);
            Object value = table.property(DELIMITER_PROPERTY);
            if (value != null) {
                jsonMap.put(DELIMITER_PROPERTY, value);
            }
            return jsonMap;
        }

        @Override
        public InputFormat convert(ResolvedTable table) {
            return (InputFormat)table.jsonMapper().convertValue(this.gatherFields(table), DelimitedInputFormat.class);
        }
    }

    public static class CsvFormatDefn
    extends FlatTextFormatDefn {
        public CsvFormatDefn() {
            super("CSV", InputFormats.CSV_FORMAT_TYPE, null);
        }

        @Override
        protected Map<String, Object> gatherFields(ResolvedTable table) {
            Map<String, Object> jsonMap = super.gatherFields(table);
            jsonMap.put("type", InputFormats.CSV_FORMAT_TYPE);
            return jsonMap;
        }

        @Override
        public InputFormat convert(ResolvedTable table) {
            try {
                return (InputFormat)table.jsonMapper().convertValue(this.gatherFields(table), CsvInputFormat.class);
            }
            catch (Exception e) {
                throw new IAE((Throwable)e, "Invalid format specification", new Object[0]);
            }
        }
    }

    public static abstract class FlatTextFormatDefn
    extends BaseFormatDefn {
        public static final String LIST_DELIMITER_PROPERTY = "listDelimiter";
        public static final String SKIP_ROWS_PROPERTY = "skipRows";

        public FlatTextFormatDefn(String name, String typeTag, List<ModelProperties.PropertyDefn<?>> properties) {
            super(name, typeTag, CatalogUtils.concatLists(Arrays.asList(new ModelProperties.StringPropertyDefn(LIST_DELIMITER_PROPERTY), new ModelProperties.IntPropertyDefn(SKIP_ROWS_PROPERTY)), properties));
        }

        protected Map<String, Object> gatherFields(ResolvedTable table) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("type", InputFormats.CSV_FORMAT_TYPE);
            jsonMap.put(LIST_DELIMITER_PROPERTY, table.property(LIST_DELIMITER_PROPERTY));
            jsonMap.put("hasHeaderRow", false);
            jsonMap.put("findColumnsFromHeader", false);
            List cols = table.spec().columns().stream().map(col -> col.name()).collect(Collectors.toList());
            jsonMap.put("columns", cols);
            Object value = table.property(SKIP_ROWS_PROPERTY);
            jsonMap.put("skipHeaderRows", value == null ? Integer.valueOf(0) : value);
            return jsonMap;
        }
    }

    public static abstract class BaseFormatDefn
    implements InputFormatDefn {
        private final String name;
        private final String typeTag;
        private final List<ModelProperties.PropertyDefn<?>> properties;

        public BaseFormatDefn(String name, String typeTag, List<ModelProperties.PropertyDefn<?>> properties) {
            this.name = name;
            this.typeTag = typeTag;
            this.properties = properties;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String typeTag() {
            return this.typeTag;
        }

        @Override
        public List<ModelProperties.PropertyDefn<?>> properties() {
            return this.properties;
        }

        @Override
        public void validate(ResolvedTable table) {
            this.convert(table);
        }
    }

    public static interface InputFormatDefn {
        public String name();

        public String typeTag();

        public List<ModelProperties.PropertyDefn<?>> properties();

        public void validate(ResolvedTable var1);

        public InputFormat convert(ResolvedTable var1);
    }
}

