/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnDefn;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ParameterizedDefn;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputFormats;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CollectionUtils;

public abstract class ExternalTableDefn
extends TableDefn {
    public static final String EXTERNAL_COLUMN_TYPE = "extern";
    protected static final ExternalColumnDefn INPUT_COLUMN_DEFN = new ExternalColumnDefn();
    private final List<ParameterizedDefn.ParameterDefn> parameterList;
    private final Map<String, ParameterizedDefn.ParameterDefn> parameterMap;

    public ExternalTableDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> fields, List<ColumnDefn> columnDefns, List<ParameterizedDefn.ParameterDefn> parameters) {
        super(name, typeValue, fields, columnDefns);
        if (CollectionUtils.isNullOrEmpty(parameters)) {
            this.parameterMap = null;
            this.parameterList = null;
        } else {
            this.parameterList = parameters;
            HashMap<String, ParameterizedDefn.ParameterDefn> params = new HashMap<String, ParameterizedDefn.ParameterDefn>();
            for (ParameterizedDefn.ParameterDefn param : parameters) {
                if (params.put(param.name(), param) == null) continue;
                throw new ISE("Duplicate parameter: %s", new Object[]{param.name()});
            }
            this.parameterMap = ImmutableMap.copyOf(params);
        }
    }

    public List<ParameterizedDefn.ParameterDefn> parameters() {
        return this.parameterList;
    }

    public ParameterizedDefn.ParameterDefn parameter(String key) {
        return this.parameterMap.get(key);
    }

    public abstract ResolvedTable mergeParameters(ResolvedTable var1, Map<String, Object> var2);

    public ExternalTableSpec convertToExtern(ResolvedTable table) {
        return new ExternalTableSpec(this.convertSource(table), this.convertFormat(table), Columns.convertSignature(table.spec()));
    }

    protected abstract InputSource convertSource(ResolvedTable var1);

    protected InputFormat convertFormat(ResolvedTable table) {
        return null;
    }

    protected InputSource convertObject(ObjectMapper jsonMapper, Map<String, Object> jsonMap, Class<? extends InputSource> targetClass) {
        try {
            return (InputSource)jsonMapper.convertValue(jsonMap, targetClass);
        }
        catch (Exception e) {
            throw new IAE((Throwable)e, "Invalid table specification", new Object[0]);
        }
    }

    public ExternalTableSpec applyParameters(ResolvedTable table, Map<String, Object> parameters) {
        ResolvedTable revised = this.mergeParameters(table, parameters);
        return this.convertToExtern(revised);
    }

    public static Set<String> tableTypes() {
        return ImmutableSet.of((Object)"inline", (Object)"http", (Object)"local");
    }

    public static class ExternalColumnDefn
    extends ColumnDefn {
        public ExternalColumnDefn() {
            super("Column", ExternalTableDefn.EXTERNAL_COLUMN_TYPE, null);
        }

        @Override
        public void validate(ColumnSpec spec, ObjectMapper jsonMapper) {
            super.validate(spec, jsonMapper);
            this.validateScalarColumn(spec);
        }
    }

    public static abstract class FormattedExternalTableDefn
    extends ExternalTableDefn {
        public static final String FORMAT_PROPERTY = "format";
        private final Map<String, InputFormats.InputFormatDefn> formats;

        public FormattedExternalTableDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> properties, List<ColumnDefn> columnDefns, List<InputFormats.InputFormatDefn> formats, List<ParameterizedDefn.ParameterDefn> parameters) {
            super(name, typeValue, FormattedExternalTableDefn.addFormatProperties(properties, formats), columnDefns, parameters);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (InputFormats.InputFormatDefn format : formats) {
                builder.put((Object)format.typeTag(), (Object)format);
            }
            this.formats = builder.build();
        }

        private static List<ModelProperties.PropertyDefn<?>> addFormatProperties(List<ModelProperties.PropertyDefn<?>> properties, List<InputFormats.InputFormatDefn> formats) {
            ArrayList toAdd = new ArrayList();
            HashMap formatProps = new HashMap();
            for (InputFormats.InputFormatDefn format : formats) {
                for (ModelProperties.PropertyDefn<?> prop : format.properties()) {
                    ModelProperties.PropertyDefn<?> existing = formatProps.putIfAbsent(prop.name(), prop);
                    if (existing == null) {
                        toAdd.add(prop);
                        continue;
                    }
                    if (existing.getClass() == prop.getClass()) continue;
                    throw new ISE("Format %s, property %s of class %s conflicts with another format property of class %s", new Object[]{format.name(), prop.name(), prop.getClass().getSimpleName(), existing.getClass().getSimpleName()});
                }
            }
            return CatalogUtils.concatLists(properties, toAdd);
        }

        @Override
        protected InputFormat convertFormat(ResolvedTable table) {
            return this.formatDefn(table).convert(table);
        }

        protected InputFormats.InputFormatDefn formatDefn(ResolvedTable table) {
            String formatTag = table.stringProperty(FORMAT_PROPERTY);
            if (formatTag == null) {
                throw new IAE("%s property must be set", new Object[]{FORMAT_PROPERTY});
            }
            InputFormats.InputFormatDefn formatDefn = this.formats.get(formatTag);
            if (formatDefn == null) {
                throw new IAE("Format type [%s] for property %s is not valid", new Object[]{formatTag, FORMAT_PROPERTY});
            }
            return formatDefn;
        }

        @Override
        public void validate(ResolvedTable table) {
            super.validate(table);
            this.formatDefn(table).validate(table);
            List<ColumnSpec> columns = table.spec().columns();
            if (columns == null || columns.isEmpty()) {
                throw new IAE("An external table of type %s must specify one or more columns", new Object[]{table.spec().type()});
            }
        }
    }
}

