/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache.polling;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.server.lookup.cache.polling.PollingCache;
import org.apache.druid.server.lookup.cache.polling.PollingCacheFactory;

public class OnHeapPollingCache<K, V>
implements PollingCache<K, V> {
    private final ImmutableMap<K, V> immutableMap;
    private final ImmutableMap<V, List<K>> immutableReverseMap;

    public OnHeapPollingCache(Iterable<Map.Entry<K, V>> entries) {
        if (entries == null) {
            this.immutableMap = ImmutableMap.of();
            this.immutableReverseMap = ImmutableMap.of();
        } else {
            ImmutableSet.Builder setOfValuesBuilder = ImmutableSet.builder();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (Map.Entry<K, V> entry : entries) {
                setOfValuesBuilder.add(entry.getValue());
                mapBuilder.put(entry.getKey(), entry.getValue());
            }
            ImmutableSet setOfValues = setOfValuesBuilder.build();
            this.immutableMap = mapBuilder.build();
            this.immutableReverseMap = ImmutableMap.copyOf((Map)Maps.asMap((Set)setOfValues, val -> this.immutableMap.keySet().stream().filter(key -> {
                Object retVal = this.immutableMap.get(key);
                return retVal != null && retVal.equals(val);
            }).collect(Collectors.toList())));
        }
    }

    @Override
    public V get(K key) {
        return (V)this.immutableMap.get(key);
    }

    @Override
    public List<K> getKeys(V value) {
        List listOfKeys = (List)this.immutableReverseMap.get(value);
        if (listOfKeys == null) {
            return Collections.emptyList();
        }
        return listOfKeys;
    }

    @Override
    public long estimateHeapFootprint() {
        for (Map.Entry entry : this.immutableMap.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            return 0L;
        }
        return MapLookupExtractor.estimateHeapFootprint(this.immutableMap);
    }

    @Override
    public void close() {
    }

    public static class OnHeapPollingCacheProvider<K, V>
    implements PollingCacheFactory<K, V> {
        @Override
        public PollingCache makeOf(Iterable<Map.Entry<K, V>> entries) {
            return new OnHeapPollingCache<K, V>(entries);
        }
    }
}

