/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.server.lookup.DataFetcher;
import org.apache.druid.server.lookup.LookupExtractionModule;
import org.apache.druid.server.lookup.cache.loading.LoadingCache;

public class LoadingLookup
extends LookupExtractor {
    private static final Logger LOGGER = new Logger(LoadingLookup.class);
    private final DataFetcher<String, String> dataFetcher;
    private final LoadingCache<String, String> loadingCache;
    private final LoadingCache<String, List<String>> reverseLoadingCache;
    private final AtomicBoolean isOpen;
    private final String id = Integer.toHexString(System.identityHashCode((Object)this));

    public LoadingLookup(DataFetcher dataFetcher, LoadingCache<String, String> loadingCache, LoadingCache<String, List<String>> reverseLoadingCache) {
        this.dataFetcher = (DataFetcher)Preconditions.checkNotNull((Object)dataFetcher, (Object)"lookup must have a DataFetcher");
        this.loadingCache = (LoadingCache)Preconditions.checkNotNull(loadingCache, (Object)"loading lookup need a cache");
        this.reverseLoadingCache = (LoadingCache)Preconditions.checkNotNull(reverseLoadingCache, (Object)"loading lookup need reverse cache");
        this.isOpen = new AtomicBoolean(true);
    }

    public String apply(@Nullable String key) {
        String keyEquivalent = NullHandling.nullToEmptyIfNeeded((String)key);
        if (keyEquivalent == null) {
            return null;
        }
        try {
            String presentVal = this.loadingCache.get(keyEquivalent, new ApplyCallable(keyEquivalent));
            return NullHandling.emptyToNullIfNeeded((String)presentVal);
        }
        catch (ExecutionException e) {
            LOGGER.debug("value not found for key [%s]", new Object[]{key});
            return null;
        }
    }

    public List<String> unapply(@Nullable String value) {
        String valueEquivalent = NullHandling.nullToEmptyIfNeeded((String)value);
        if (valueEquivalent == null) {
            return Collections.emptyList();
        }
        try {
            List<String> retList = this.reverseLoadingCache.get(valueEquivalent, new UnapplyCallable(valueEquivalent));
            return retList;
        }
        catch (ExecutionException e) {
            LOGGER.debug("list of keys not found for value [%s]", new Object[]{value});
            return Collections.emptyList();
        }
    }

    public boolean canIterate() {
        return false;
    }

    public boolean canGetKeySet() {
        return false;
    }

    public Iterable<Map.Entry<String, String>> iterable() {
        throw new UnsupportedOperationException("Cannot iterate");
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException("Cannot get key set");
    }

    public byte[] getCacheKey() {
        return LookupExtractionModule.getRandomCacheKey();
    }

    public synchronized void close() {
        if (this.isOpen.getAndSet(false)) {
            LOGGER.info("Closing loading cache [%s]", new Object[]{this.id});
            this.loadingCache.close();
            this.reverseLoadingCache.close();
        } else {
            LOGGER.info("Closing already closed lookup", new Object[0]);
        }
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public String toString() {
        return "LoadingLookup{dataFetcher=" + this.dataFetcher + ", id='" + this.id + '\'' + '}';
    }

    private class UnapplyCallable
    implements Callable<List<String>> {
        private final String value;

        public UnapplyCallable(String value) {
            this.value = value;
        }

        @Override
        public List<String> call() {
            return LoadingLookup.this.dataFetcher.reverseFetchKeys(this.value);
        }
    }

    private class ApplyCallable
    implements Callable<String> {
        private final String key;

        public ApplyCallable(String key) {
            this.key = key;
        }

        @Override
        public String call() {
            return NullHandling.nullToEmptyIfNeeded((String)((String)LoadingLookup.this.dataFetcher.fetch(this.key)));
        }
    }
}

