/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.hdfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.druid.common.utils.UUIDUtils;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CompressionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HadoopFsWrapper;
import org.apache.hadoop.fs.Path;
import org.joda.time.format.ISODateTimeFormat;

public class HdfsDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(HdfsDataSegmentPusher.class);
    private final Configuration hadoopConfig;
    private final Supplier<String> fullyQualifiedStorageDirectory;

    @Inject
    public HdfsDataSegmentPusher(HdfsDataSegmentPusherConfig config, @Hdfs Configuration hadoopConfig, ObjectMapper jsonMapper) {
        this.hadoopConfig = hadoopConfig;
        Path storageDir = new Path(config.getStorageDirectory());
        this.fullyQualifiedStorageDirectory = Suppliers.memoize(() -> {
            try {
                return FileSystem.newInstance((URI)storageDir.toUri(), (Configuration)hadoopConfig).makeQualified(storageDir).toUri().toString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Deprecated
    public String getPathForHadoop(String dataSource) {
        return this.getPathForHadoop();
    }

    public String getPathForHadoop() {
        return (String)this.fullyQualifiedStorageDirectory.get();
    }

    public DataSegment push(File inDir, DataSegment segment, boolean useUniquePath) throws IOException {
        String storageDir = this.getStorageDir(segment, false);
        String uniquePrefix = useUniquePath ? DataSegmentPusher.generateUniquePath() + "_" : "";
        String outIndexFilePathSuffix = StringUtils.format((String)"%s/%d_%sindex.zip", (Object[])new Object[]{storageDir, segment.getShardSpec().getPartitionNum(), uniquePrefix});
        return this.pushToPath(inDir, segment, outIndexFilePathSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSegment pushToPath(File inDir, DataSegment segment, String storageDirSuffix) throws IOException {
        DataSegment dataSegment;
        log.debug("Copying segment[%s] to HDFS at location[%s/%s]", new Object[]{segment.getId(), this.fullyQualifiedStorageDirectory.get(), storageDirSuffix});
        String storageDir = StringUtils.format((String)"%s/%s", (Object[])new Object[]{this.fullyQualifiedStorageDirectory.get(), storageDirSuffix});
        Path tmpIndexFile = new Path(StringUtils.format((String)"%s/%s/%s/%s_index.zip", (Object[])new Object[]{this.fullyQualifiedStorageDirectory.get(), segment.getDataSource(), UUIDUtils.generateUuid((String[])new String[0]), segment.getShardSpec().getPartitionNum()}));
        FileSystem fs = tmpIndexFile.getFileSystem(this.hadoopConfig);
        fs.mkdirs(tmpIndexFile.getParent());
        log.debug("Compressing files from[%s] to [%s]", new Object[]{inDir, tmpIndexFile});
        try {
            long size;
            try (FSDataOutputStream out = fs.create(tmpIndexFile);){
                size = CompressionUtils.zip((File)inDir, (OutputStream)out);
            }
            Path outIndexFile = new Path(storageDir);
            dataSegment = segment.withLoadSpec(this.makeLoadSpec(outIndexFile.toUri())).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir((File)inDir));
            fs.mkdirs(outIndexFile.getParent());
            this.copyFilesWithChecks(fs, tmpIndexFile, outIndexFile);
        }
        catch (Throwable throwable) {
            try {
                if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                    log.error("Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
                }
            }
            catch (IOException ex) {
                log.error((Throwable)ex, "Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
            }
            throw throwable;
        }
        try {
            if (fs.exists(tmpIndexFile.getParent()) && !fs.delete(tmpIndexFile.getParent(), true)) {
                log.error("Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
            }
        }
        catch (IOException ex) {
            log.error((Throwable)ex, "Failed to delete temp directory[%s]", new Object[]{tmpIndexFile.getParent()});
        }
        return dataSegment;
    }

    private void copyFilesWithChecks(FileSystem fs, Path from, Path to) throws IOException {
        if (!HadoopFsWrapper.rename(fs, from, to)) {
            if (fs.exists(to)) {
                log.info("Unable to rename temp file [%s] to segment path [%s], it may have already been pushed by a replica task.", new Object[]{from, to});
            } else {
                throw new IOE("Failed to rename temp file [%s] and final segment path [%s] is not present.", new Object[]{from, to});
            }
        }
    }

    public Map<String, Object> makeLoadSpec(URI finalIndexZipFilePath) {
        return ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)finalIndexZipFilePath.toString());
    }

    public String getStorageDir(DataSegment segment, boolean useUniquePath) {
        Preconditions.checkArgument((!useUniquePath ? 1 : 0) != 0, (Object)"useUniquePath must be false for HdfsDataSegmentPusher.getStorageDir()");
        return JOINER.join((Object)segment.getDataSource(), (Object)StringUtils.format((String)"%s_%s", (Object[])new Object[]{segment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), segment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())}), new Object[]{segment.getVersion().replace(':', '_')});
    }

    public String makeIndexPathName(DataSegment dataSegment, String indexName) {
        return StringUtils.format((String)"./%s/%d_%s", (Object[])new Object[]{this.getStorageDir(dataSegment, false), dataSegment.getShardSpec().getPartitionNum(), indexName});
    }
}

