/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.inputsource.hdfs;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.storage.hdfs.HdfsDataSegmentPuller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsInputEntity
extends RetryingInputEntity {
    private final Configuration conf;
    private final Path path;

    HdfsInputEntity(Configuration conf, Path path) {
        this.conf = conf;
        this.path = path;
    }

    public URI getUri() {
        return this.path.toUri();
    }

    protected InputStream readFrom(long offset) throws IOException {
        FileSystem fs = this.path.getFileSystem(this.conf);
        FSDataInputStream inputStream = fs.open(this.path);
        inputStream.seek(offset);
        return inputStream;
    }

    protected String getPath() {
        return this.path.getName();
    }

    public Predicate<Throwable> getRetryCondition() {
        return HdfsDataSegmentPuller.RETRY_PREDICATE;
    }
}

