/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.indexing.seekablestream.supervisor.IdleConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.java.util.common.IAE;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;

public abstract class SeekableStreamSupervisorIOConfig {
    private final String stream;
    @Nullable
    private final InputFormat inputFormat;
    private final Integer replicas;
    private Integer taskCount;
    private final Duration taskDuration;
    private final Duration startDelay;
    private final Duration period;
    private final boolean useEarliestSequenceNumber;
    private final Duration completionTimeout;
    private final Optional<Duration> lateMessageRejectionPeriod;
    private final Optional<Duration> earlyMessageRejectionPeriod;
    private final Optional<DateTime> lateMessageRejectionStartDateTime;
    @Nullable
    private final AutoScalerConfig autoScalerConfig;
    @Nullable
    private final IdleConfig idleConfig;

    public SeekableStreamSupervisorIOConfig(String stream, @Nullable InputFormat inputFormat, Integer replicas, Integer taskCount, Period taskDuration, Period startDelay, Period period, Boolean useEarliestSequenceNumber, Period completionTimeout, Period lateMessageRejectionPeriod, Period earlyMessageRejectionPeriod, @Nullable AutoScalerConfig autoScalerConfig, DateTime lateMessageRejectionStartDateTime, @Nullable IdleConfig idleConfig) {
        this.stream = (String)Preconditions.checkNotNull((Object)stream, (Object)"stream cannot be null");
        this.inputFormat = inputFormat;
        this.replicas = replicas != null ? replicas : 1;
        this.autoScalerConfig = autoScalerConfig;
        this.taskCount = autoScalerConfig != null && autoScalerConfig.getEnableTaskAutoScaler() ? Integer.valueOf(autoScalerConfig.getTaskCountMin()) : Integer.valueOf(taskCount != null ? taskCount : 1);
        this.taskDuration = SeekableStreamSupervisorIOConfig.defaultDuration(taskDuration, "PT1H");
        this.startDelay = SeekableStreamSupervisorIOConfig.defaultDuration(startDelay, "PT5S");
        this.period = SeekableStreamSupervisorIOConfig.defaultDuration(period, "PT30S");
        this.useEarliestSequenceNumber = useEarliestSequenceNumber != null ? useEarliestSequenceNumber : false;
        this.completionTimeout = SeekableStreamSupervisorIOConfig.defaultDuration(completionTimeout, "PT30M");
        this.lateMessageRejectionPeriod = lateMessageRejectionPeriod == null ? Optional.absent() : Optional.of((Object)lateMessageRejectionPeriod.toStandardDuration());
        this.lateMessageRejectionStartDateTime = lateMessageRejectionStartDateTime == null ? Optional.absent() : Optional.of((Object)lateMessageRejectionStartDateTime);
        Optional optional = this.earlyMessageRejectionPeriod = earlyMessageRejectionPeriod == null ? Optional.absent() : Optional.of((Object)earlyMessageRejectionPeriod.toStandardDuration());
        if (this.lateMessageRejectionPeriod.isPresent() && this.lateMessageRejectionStartDateTime.isPresent()) {
            throw new IAE("SeekableStreamSupervisorIOConfig does not support both properties lateMessageRejectionStartDateTime and lateMessageRejectionPeriod.", new Object[0]);
        }
        this.idleConfig = idleConfig;
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }

    @JsonProperty
    public String getStream() {
        return this.stream;
    }

    @Nullable
    @JsonProperty
    public InputFormat getInputFormat() {
        return this.inputFormat;
    }

    @JsonProperty
    public Integer getReplicas() {
        return this.replicas;
    }

    @Nullable
    @JsonProperty
    public AutoScalerConfig getAutoScalerConfig() {
        return this.autoScalerConfig;
    }

    @JsonProperty
    public Integer getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    @JsonProperty
    public Duration getTaskDuration() {
        return this.taskDuration;
    }

    @JsonProperty
    public Duration getStartDelay() {
        return this.startDelay;
    }

    @JsonProperty
    public Duration getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isUseEarliestSequenceNumber() {
        return this.useEarliestSequenceNumber;
    }

    @JsonProperty
    public Duration getCompletionTimeout() {
        return this.completionTimeout;
    }

    @JsonProperty
    public Optional<Duration> getEarlyMessageRejectionPeriod() {
        return this.earlyMessageRejectionPeriod;
    }

    @JsonProperty
    public Optional<Duration> getLateMessageRejectionPeriod() {
        return this.lateMessageRejectionPeriod;
    }

    @JsonProperty
    public Optional<DateTime> getLateMessageRejectionStartDateTime() {
        return this.lateMessageRejectionStartDateTime;
    }

    @Nullable
    @JsonProperty
    public IdleConfig getIdleConfig() {
        return this.idleConfig;
    }
}

