/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.indexing.seekablestream.SettableByteEntity;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.TransformingInputEntityReader;

class SettableByteEntityReader<T extends ByteEntity>
implements InputEntityReader {
    private final SettableByteEntity<T> entity;
    private final InputEntityReader delegate;

    SettableByteEntityReader(InputFormat inputFormat, InputRowSchema inputRowSchema, TransformSpec transformSpec, File indexingTmpDir) {
        Preconditions.checkNotNull((Object)inputFormat, (Object)"inputFormat");
        InputFormat format = inputFormat instanceof JsonInputFormat ? ((JsonInputFormat)inputFormat).withLineSplittable(false) : inputFormat;
        this.entity = new SettableByteEntity();
        this.delegate = new TransformingInputEntityReader(format.createReader(inputRowSchema, this.entity, indexingTmpDir), transformSpec.toTransformer());
    }

    void setEntity(T entity) {
        this.entity.setEntity(entity);
    }

    public CloseableIterator<InputRow> read() throws IOException {
        return this.delegate.read();
    }

    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        return this.delegate.sample();
    }
}

