/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClient;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientAsyncImpl;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientSyncImpl;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.rpc.ServiceClientFactory;

public abstract class SeekableStreamIndexTaskClientFactory<PartitionIdType, SequenceOffsetType> {
    private static final Logger log = new Logger(SeekableStreamIndexTaskClientFactory.class);
    private final ServiceClientFactory serviceClientFactory;
    private final HttpClient httpClient;
    private final ObjectMapper jsonMapper;

    protected SeekableStreamIndexTaskClientFactory(ServiceClientFactory serviceClientFactory, HttpClient httpClient, ObjectMapper jsonMapper) {
        this.serviceClientFactory = serviceClientFactory;
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
    }

    public SeekableStreamIndexTaskClient<PartitionIdType, SequenceOffsetType> build(String dataSource, TaskInfoProvider taskInfoProvider, int maxNumTasks, SeekableStreamSupervisorTuningConfig tuningConfig) {
        if (tuningConfig.getChatAsync()) {
            return this.buildAsync(dataSource, taskInfoProvider, tuningConfig);
        }
        return this.buildSync(dataSource, taskInfoProvider, maxNumTasks, tuningConfig);
    }

    SeekableStreamIndexTaskClient<PartitionIdType, SequenceOffsetType> buildAsync(String dataSource, TaskInfoProvider taskInfoProvider, SeekableStreamSupervisorTuningConfig tuningConfig) {
        log.info("Created async task client for dataSource[%s] httpTimeout[%s] chatRetries[%d]", new Object[]{dataSource, tuningConfig.getHttpTimeout(), tuningConfig.getChatRetries()});
        return new SeekableStreamIndexTaskClientAsyncImpl<PartitionIdType, SequenceOffsetType>(dataSource, this.serviceClientFactory, taskInfoProvider, this.jsonMapper, tuningConfig.getHttpTimeout(), tuningConfig.getChatRetries()){

            @Override
            public Class<PartitionIdType> getPartitionType() {
                return SeekableStreamIndexTaskClientFactory.this.getPartitionType();
            }

            @Override
            public Class<SequenceOffsetType> getSequenceType() {
                return SeekableStreamIndexTaskClientFactory.this.getSequenceType();
            }
        };
    }

    private SeekableStreamIndexTaskClient<PartitionIdType, SequenceOffsetType> buildSync(String dataSource, TaskInfoProvider taskInfoProvider, int maxNumTasks, SeekableStreamSupervisorTuningConfig tuningConfig) {
        int chatThreads = tuningConfig.getChatThreads() != null ? tuningConfig.getChatThreads() : Math.min(10, maxNumTasks);
        log.info("Created taskClient for dataSource[%s] chatThreads[%d] httpTimeout[%s] chatRetries[%d]", new Object[]{dataSource, chatThreads, tuningConfig.getHttpTimeout(), tuningConfig.getChatRetries()});
        return new SeekableStreamIndexTaskClientSyncImpl<PartitionIdType, SequenceOffsetType>(this.httpClient, this.jsonMapper, taskInfoProvider, dataSource, chatThreads, tuningConfig.getHttpTimeout(), tuningConfig.getChatRetries()){

            @Override
            public Class<PartitionIdType> getPartitionType() {
                return SeekableStreamIndexTaskClientFactory.this.getPartitionType();
            }

            @Override
            public Class<SequenceOffsetType> getSequenceType() {
                return SeekableStreamIndexTaskClientFactory.this.getSequenceType();
            }
        };
    }

    protected abstract Class<PartitionIdType> getPartitionType();

    protected abstract Class<SequenceOffsetType> getSequenceType();
}

