/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.joda.time.Interval;

public class WindowedSegmentId {
    private final String segmentId;
    private final List<Interval> intervals;

    @JsonCreator
    public WindowedSegmentId(@JsonProperty(value="segmentId") String segmentId, @JsonProperty(value="intervals") List<Interval> intervals) {
        this.segmentId = (String)Preconditions.checkNotNull((Object)segmentId, (Object)"null segmentId");
        this.intervals = (List)Preconditions.checkNotNull(intervals, (Object)"null intervals");
    }

    public void addInterval(Interval interval) {
        this.intervals.add(interval);
    }

    @JsonProperty
    public String getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return Collections.unmodifiableList(this.intervals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowedSegmentId segmentId1 = (WindowedSegmentId)o;
        return Objects.equals(this.segmentId, segmentId1.segmentId) && Objects.equals(this.intervals, segmentId1.intervals);
    }

    public int hashCode() {
        return Objects.hash(this.segmentId, this.intervals);
    }

    public String toString() {
        return "WindowedSegmentId{segmentId='" + this.segmentId + '\'' + ", intervals=" + this.intervals + '}';
    }
}

